;;; $Id: vcs-vi.el,v 1.6 26-Oct-1992 21:46:37 EST don Exp $
;;;
;;; Local support for vcs.el
;;;
;;; Copyright (C) Donald Beaudry <don@vicorp.com> 1992
;;;
;;; This file is not part of GNU Emacs, but is made available under
;;; the same conditions.
;;;
;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 1, or
;;; (at your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;
;;; $Log: vcs-vi.el,v $
;;; Revision 1.6  26-Oct-1992 21:46:37 EST  don
;;; fixed up to work with the new form stuff
;;;
;;; Revision 1.5  23-Sep-1992 19:06:42 EDT  don
;;; Fixed up the finish-put routine... trapped error on the delete-file calls
;;; and added a chmod after copying the file
;;;
;;; Revision 1.4  16-Sep-1992 21:28:58 EDT  don
;;; Fixed up the hack that gets around the bug in Delta
;;;
;;; Revision 1.3  12-Sep-1992 19:31:39 EDT  don
;;; Added a copyleft notice
;;;
;;; 

;;
;; NOTE: this is sample code... it won't do you any good to try and
;; use it.  vcs-init.el won't even try to load it.
;;



(require 'form)

;;;
;;;
;;;
(defform vcs-vi-put
  "Major mode checking files into V.I.'s development area"
  (when-finished vcs-vi-finish-put)
  (buffer vcs-put-buffer)
  (mode-name "VCS-vi-put")
  (initial-field 'product-code)
  (text "                       ====== V.I. Put ======\n\n\n")
  (field history-file
	 (prompt "History File: ")
	 (default history-file)
  	 (verifier (lambda (b e)
		     (if (< b e)
			 t
		       (error "A history file must be specified")))))
  (text "\n")
  (field working-file
	 (prompt "Working File: ")
	 (default working-file)
	 (verifier (lambda (b e)
		     (if (file-exists-p (buffer-substring b e))
			 t
		       (error "Working file does not exist")))))
  (text "\n")
  (field product-code
	 (prompt "Product:      ")
	 (default (or (and (boundp 'dv-product) dv-product)
		      (getenv "DVPRODUCT")
		      "DV9.1a")))
  (text "\n")
  (field bug-number
	 (prompt "Bug Number:   "))
  (text "\n\n")
  (field comment
	 (prompt (if (not (file-exists-p history-file))
		     "--Descriptive text--\n"
		   "--Log message--\n"))
	 (verifier (lambda (b e)
		     (if (< b e)
			 t
		       (error "A log message must be specified")))))
  (text "\n\n")
  (field porting-message
	 (prompt "--Message to Porting--\n"))
  (text "\n\n")
  (field doc-message
	 (prompt "--Message to Documentation--\n"))
  (text "\n\n--\n"))


;;;
;;;
;;;
(defun vcs-vi-setup-for-put (history-file working-file)
  (if (string-match "^/vi/develop/" history-file)
      (progn
	(vcs-vi-put-mode nil vcs-use-other-window)
	(setq default-directory (file-name-directory working-file))
	(run-hooks 'vcs-put-mode-hooks)
	t)))

(vcs-add-hook 'vcs-put-hooks 'vcs-vi-setup-for-put)


;;;
;;;
;;;
(defun vcs-vi-finish-put (put-data)
  (if (equal (current-buffer) (get-buffer vcs-put-buffer))
      nil
    (error "Wrong buffer"))
  (let* ((history-file (form-field-string 'history-file put-data))
	 (working-file (form-field-string 'working-file put-data))
	 (comment-region (form-field-region 'comment put-data))
	 (comment-file (concat vcs-temp-dir "/" (make-temp-name "vcs-cmnt")))
	 (comment-region (form-field-region 'comment put-data))
	 (buf (get-file-buffer working-file))
	 (port-message-file (concat vcs-temp-dir "/"
				    (make-temp-name "vcs-prtmsg")))
	 (port-message-region (form-field-region 'porting-message put-data))
	 (doc-message-file (concat vcs-temp-dir "/"
				   (make-temp-name "vcs-doc"))) 
	 (doc-message-region (form-field-region 'doc-message put-data))
	 (product-code (form-field-string 'product-code put-data))
	 (bug-number (form-field-string 'bug-number put-data))
	 (directory (expand-file-name
		     (concat (file-name-directory history-file) ".."))))

    (if (and buf (buffer-modified-p buf))
	(save-excursion
	  (set-buffer buf)
	  (if (y-or-n-p (concat "Save " buffer-file-name "? "))
	      (save-buffer))))

    (if (<= (car comment-region) (cdr comment-region))
	(write-region (car comment-region) (cdr comment-region)
		      comment-file nil 'no-message))
    (if (<= (car port-message-region) (cdr port-message-region))
	(write-region (car port-message-region) (cdr port-message-region)
		      port-message-file nil 'no-message))
    (if (<= (car doc-message-region) (cdr doc-message-region))
	(write-region (car doc-message-region) (cdr doc-message-region)
		      doc-message-file nil 'no-message))
      
    (if (string-match "^[ \t\n]*$" product-code)
	(setq product-code nil))

    (if (string-match "^[ \t\n]*$" bug-number)
	(setq bug-number nil))
    
    (message "Checking in %s..." history-file)
    (unwind-protect
	(vcs-execute-command (file-name-directory working-file)
			     "rm -f"
			     (concat directory "/"
				     (file-name-nondirectory working-file))
			     "\ncp" working-file directory
			     "\nchmod ugo-w"
			     (concat directory "/"
				     (file-name-nondirectory working-file))
			     "\nDelta -Y"
			     "-C" comment-file
			     "-P" port-message-file
			     "-D" doc-message-file
			     (if product-code
				 (concat "-p " product-code)
			       "")
			     (if bug-number
				 (concat "-b " bug-number)
			       "")
			     "-d" directory
			     (file-name-nondirectory working-file))
      (condition-case nil
	  (delete-file comment-file)
	(file-error nil))
      (condition-case nil
	  (delete-file port-message-file)
	(file-error nil))
      (condition-case nil
	  (delete-file doc-message-file)
	(file-error nil))
      (message "Checked in %s..." history-file))
    
    (vcs-cleanup-after-put history-file working-file)
    t))

