#define banner "This is CTANGLE ($Revision: 2.1 $)\n" \
 \
 \

#define max_bytes 90000 \

#define max_tokmem 270000
#define max_names 4000 \

#define max_textmem 2500
#define hash_size 353
#define longest_name 400
#define stack_size_max 50
#define buf_size 100 \
 \
 \

#define and_and 04
#define lt_lt 020
#define gt_gt 021
#define plus_plus 013
#define minus_minus 01
#define minus_gt 031
#define not_eq 032
#define lt_eq 034
#define gt_eq 035
#define eq_eq 036
#define or_or 037 \

#line 1 "common.h"

#define tangle 0
#define weave 1 \

#define false (boolean)0
#define true (boolean)1 \

#define max_bytes 90000 \

#define max_names 4000 \

#define max_modules 2000
#define hash_size 353
#define hash_end (hash+hash_size-1)
#define buf_size 100
#define longest_name 400
#define long_buf_size 500
#define line_length 80 \

#define max_refs 20000
#define max_toks 20000 \

#define max_texts 2000 \

#define max_scraps 1000
#define stack_size 400 \
 \

#define mod_text_end (mod_text+longest_name) \

#define name_begin(p)((p)->byte_start)
#define name_end(p)((p+1)->byte_start)
#define length(p)(name_end(p)-name_begin(p))
#define print_id(p)term_write(name_begin(p),length(p)) \

#define llink link
#define rlink dummy.Rlink
#define root name_dir->rlink \
 \

#define spotless 0
#define harmless_message 1
#define error_message 2
#define fatal_message 3
#define mark_harmless {if(history==spotless)history= harmless_message;}
#define mark_error history= error_message
#define confusion(s)fatal("! This can't happen: ",s)
#define fatal(s,t){ \
printf(s);err_print(t); \
history= fatal_message;wrap_up(); \
}
#define overflow(t){ \
printf("\n! Sorry, %s capacity exceeded",t);fatal("",""); \
} \

#define max_file_name_length 60
#define cur_file file[include_depth]
#define cur_file_name file_name[include_depth]
#define web_file_name file_name[0]
#define cur_line line[include_depth] \

#define show_banner flags['b']
#define show_progress flags['p']
#define show_happiness flags['h'] \

#define update_terminal fflush(stdout)
#define new_line putchar('\n')
#define putxchar putchar
#define term_write(a,b)printf("%.*s",b,a)
#define C_printf(c,a)fprintf(C_file,c,a)
#define C_putc(c)putc(c,C_file) \

#define equiv equiv_or_xref \
 \
 \

#define module_flag max_textmem \

#define string 02
#define join 0177 \
 \
 \

#define cur_end cur_state.end_field
#define cur_byte cur_state.byte_field
#define cur_name cur_state.name_field
#define cur_repl cur_state.repl_field
#define cur_mod cur_state.mod_field \

#define module_number 0201
#define identifier 0202 \

#define misc 0
#define num_or_id 1
#define unbreakable 3
#define verbatim 4 \

#define max_files 256
#define ignore 0
#define ord 0302
#define control_text 0303
#define format 0304
#define definition 0305
#define begin_C 0306
#define module_name 0307
#define new_module 0310 \

#define constant 03 \

#define compress(c)if(loc++<=limit)return(c) \

#define macro 0
#define app_repl(c){if(tok_ptr==tok_mem_end)overflow("token");*tok_ptr++= c;} \

/*2:*/
#line 79 "ctangle.w"

/*8:*/
#line 85 "common.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>

/*:8*/
#line 80 "ctangle.w"

/*6:*/
#line 39 "common.h"

typedef short boolean;
typedef unsigned char eight_bits;
extern int program;
extern int phase;
extern boolean C_plus_plus;

void common_init(),print_stats();
void init_node();
boolean names_match();
void init_p();

int tolower();
int fflush(),fclose(),ungetc();
int printf();
int fprintf();
int _flsbuf(),_filbuf();


/*:6*//*9:*/
#line 96 "common.h"

extern char mod_text[];
extern char*id_first;
extern char*id_loc;

/*:9*//*10:*/
#line 103 "common.h"

extern char buffer[];
extern char*loc;
extern char*limit;

/*:10*//*11:*/
#line 119 "common.h"

typedef struct name_info{
char*byte_start;
struct name_info*link;
union{
struct name_info*Rlink;

int Ilk;
}dummy;
void*equiv_or_xref;
}name_info;
typedef name_info*name_pointer;
typedef name_pointer*hash_pointer;
extern char byte_mem[];
extern name_info name_dir[];
extern name_pointer name_ptr;
extern char*byte_ptr;
extern name_pointer hash[];
extern name_pointer id_lookup();
extern name_pointer mod_lookup();
extern name_pointer prefix_lookup();

/*:11*//*12:*/
#line 157 "common.h"

extern history;
extern void err_print();
extern void wrap_up();

/*:12*//*13:*/
#line 170 "common.h"

extern include_depth;
extern FILE*file[];
extern FILE*change_file;
extern char C_file_name[];
extern char tex_file_name[];
extern char file_name[][max_file_name_length];

extern char change_file_name[];
extern line[];
extern change_line;
extern boolean input_has_ended;
extern boolean changing;
extern boolean web_file_open;
extern void reset_input();
extern boolean get_line();
extern void check_complete();

/*:13*//*14:*/
#line 189 "common.h"

typedef unsigned short sixteen_bits;
extern module_count;
extern boolean changed_module[];
extern boolean print_where;

/*:14*//*15:*/
#line 200 "common.h"

extern int argc;
extern char**argv;
extern boolean flags[];

/*:15*//*16:*/
#line 213 "common.h"

extern FILE*C_file;
extern FILE*tex_file;
void print_progress(),print_module_progress();
#line 142 "ctangle.w"





/*:16*/
#line 81 "ctangle.w"

/*17:*/
#line 171 "ctangle.w"

typedef struct{
eight_bits*tok_start;
sixteen_bits text_link;
}text;
typedef text*text_pointer;



/*:17*//*28:*/
#line 345 "ctangle.w"

typedef struct{
eight_bits*end_field;
eight_bits*byte_field;
name_pointer name_field;
text_pointer repl_field;
sixteen_bits mod_field;
}output_state;
typedef output_state*stack_pointer;



/*:28*/
#line 82 "ctangle.w"

/*42:*/
#line 599 "ctangle.w"

void phase_two();

/*:42*//*46:*/
#line 696 "ctangle.w"

void out_char();

/*:46*//*84:*/
#line 1480 "ctangle.w"

void phase_one();

/*:84*/
#line 83 "ctangle.w"

/*18:*/
#line 181 "ctangle.w"

text text_info[max_textmem];
text_pointer text_info_end= text_info+max_textmem-1;
text_pointer text_ptr;
eight_bits tok_mem[max_tokmem];
eight_bits*tok_mem_end= tok_mem+max_tokmem-1;
eight_bits*tok_ptr;



/*:18*//*24:*/
#line 263 "ctangle.w"

text_pointer last_unnamed;



/*:24*//*29:*/
#line 364 "ctangle.w"

output_state cur_state;

output_state stack[stack_size_max+1];
stack_pointer stack_ptr;
stack_pointer stack_end= stack+stack_size_max;



/*:29*//*33:*/
#line 440 "ctangle.w"

int cur_val;



/*:33*//*37:*/
#line 527 "ctangle.w"

eight_bits out_state;
boolean protect;



/*:37*//*39:*/
#line 559 "ctangle.w"

name_pointer output_files[max_files];
name_pointer*cur_out_file,*end_output_files,*an_output_file;
char cur_module_char;
char output_file_name[longest_name];



/*:39*//*52:*/
#line 809 "ctangle.w"

eight_bits ccode[128];



/*:52*//*55:*/
#line 861 "ctangle.w"

boolean comment_continues= false;

/*:55*//*57:*/
#line 902 "ctangle.w"

name_pointer cur_module;



/*:57*//*70:*/
#line 1204 "ctangle.w"

text_pointer cur_text;
eight_bits next_control;



/*:70*/
#line 84 "ctangle.w"


int main(ac,av)
int ac;
char**av;
{argc= ac;argv= av;
program= tangle;
/*19:*/
#line 192 "ctangle.w"

text_info->tok_start= tok_ptr= tok_mem;
text_ptr= text_info+1;text_ptr->tok_start= tok_mem;




/*:19*//*21:*/
#line 207 "ctangle.w"

name_dir->equiv= (void*)text_info;



/*:21*//*25:*/
#line 269 "ctangle.w"

{last_unnamed= text_info;text_info->text_link= 0;
}



/*:25*//*40:*/
#line 572 "ctangle.w"

cur_out_file= end_output_files= output_files+max_files;



/*:40*//*53:*/
#line 815 "ctangle.w"

{int c;

for(c= 0;c<=127;c++)ccode[c]= ignore;
ccode[' ']= ccode['\t']= ccode['\n']= ccode['\v']= ccode['\r']= ccode['\f']
= ccode['*']= new_module;
ccode['@']= '@';ccode['=']= string;
ccode['d']= ccode['D']= definition;ccode['f']= ccode['F']= format;
ccode['c']= ccode['C']= ccode['p']= ccode['P']= begin_C;
ccode['^']= ccode[':']= ccode['.']= ccode['t']= ccode['T']= control_text;
ccode['&']= join;
ccode['<']= ccode['(']= module_name;
ccode['\'']= ord;
}



/*:53*//*66:*/
#line 1119 "ctangle.w"

mod_text[0]= ' ';



/*:66*/
#line 91 "ctangle.w"

common_init();
if(show_banner)printf(banner);
phase_one();
phase_two();
wrap_up();
return 0;
}



/*:2*//*22:*/
#line 215 "ctangle.w"

boolean names_match(p,first,l)
name_pointer p;
char*first;
int l;
{
if(length(p)!=l)return 0;
return!strncmp(first,p->byte_start,l);
}



/*:22*//*23:*/
#line 232 "ctangle.w"

void init_node(node)
name_pointer node;
{
node->equiv= (void*)text_info;
}

void init_p(){}





/*:23*//*27:*/
#line 306 "ctangle.w"

void store_two_bytes(x)
sixteen_bits x;
{
if(tok_ptr+2>tok_mem_end)overflow("token");
*tok_ptr++= x>>8;
*tok_ptr++= x&0377;
}





/*:27*//*31:*/
#line 393 "ctangle.w"

void push_level(p)
name_pointer p;
{
if(stack_ptr==stack_end)overflow("stack");
*stack_ptr= cur_state;
stack_ptr++;
cur_name= p;cur_repl= (text_pointer)p->equiv;
cur_byte= cur_repl->tok_start;cur_end= (cur_repl+1)->tok_start;
cur_mod= 0;
}



/*:31*//*32:*/
#line 411 "ctangle.w"

void pop_level()
{
if(cur_repl->text_link<module_flag){
cur_repl= cur_repl->text_link+text_info;
cur_byte= cur_repl->tok_start;cur_end= (cur_repl+1)->tok_start;
return;
}
stack_ptr--;
if(stack_ptr>stack)cur_state= *stack_ptr;
}



/*:32*//*34:*/
#line 448 "ctangle.w"

void get_output()
{sixteen_bits a;

restart:if(stack_ptr==stack)return;
if(cur_byte==cur_end){
cur_val= -((int)cur_mod);
pop_level();
if(cur_val==0)goto restart;
out_char(module_number);return;
}
a= *cur_byte++;
if(a<0200)out_char(a);
else{
a= (a-0200)*0400+*cur_byte++;
switch(a/024000){
case 0:cur_val= a;out_char(identifier);break;
case 1:/*35:*/
#line 477 "ctangle.w"

{a-= 024000;
if((a+name_dir)->equiv!=(void*)text_info)push_level(a+name_dir);
else if(a!=0){
printf("\n! Not present: <");print_id(a+name_dir);err_print(">");

}
goto restart;
}





/*:35*/
#line 465 "ctangle.w"

default:cur_val= a-050000;if(cur_val>0)cur_mod= cur_val;
out_char(module_number);
}
}
}



/*:34*//*38:*/
#line 537 "ctangle.w"

void flush_buffer()
{
C_putc('\n');
if(cur_line%100==0&&show_progress){
printf(".");
if(cur_line%500==0)printf("%d",cur_line);
update_terminal;
}
cur_line++;
}



/*:38*//*43:*/
#line 603 "ctangle.w"

void phase_two()
{phase= 2;web_file_open= 0;cur_line= 1;
/*45:*/
#line 661 "ctangle.w"

{sixteen_bits a;

for(cur_text= text_info+1;cur_text<text_ptr;cur_text++)
if(cur_text->text_link==0){
cur_byte= cur_text->tok_start;
cur_end= (cur_text+1)->tok_start;
C_printf("#define ",0);
out_state= misc;
protect= true;
while(cur_byte<cur_end){
a= *cur_byte++;
if(cur_byte==cur_end&&a=='\n')break;
if(a<0200)out_char(a);
else{
a= (a-0200)*0400+*cur_byte++;
if(a<024000){
cur_val= a;out_char(identifier);
}
else if(a<050000){confusion("macros defs have strange char");}
else{
cur_val= a-050000;cur_mod= cur_val;out_char(module_number);
}

}
}
protect= false;
flush_buffer();
}
}



/*:45*/
#line 606 "ctangle.w"

if(text_info->text_link==0&&cur_out_file==end_output_files){
printf("\n! No program text was specified.");mark_harmless;

}
else{
if(show_progress){
if(cur_out_file==end_output_files)
printf("\nWriting the output file (%s):",C_file_name);
else{printf("\nWriting the output files:");

if(text_info->text_link==0)goto writeloop;
printf(" (%s)",C_file_name);
update_terminal;
}
}
/*30:*/
#line 379 "ctangle.w"

stack_ptr= stack+1;cur_name= name_dir;cur_repl= text_info->text_link+text_info;
cur_byte= cur_repl->tok_start;cur_end= (cur_repl+1)->tok_start;cur_mod= 0;



/*:30*/
#line 622 "ctangle.w"

while(stack_ptr>stack)get_output();
flush_buffer();
writeloop:/*44:*/
#line 635 "ctangle.w"

for(an_output_file= end_output_files;an_output_file>cur_out_file;){
an_output_file--;
strncpy(output_file_name,(*an_output_file)->byte_start,longest_name);
output_file_name[length(*an_output_file)]= '\0';
fclose(C_file);
C_file= fopen(output_file_name,"w");
if(C_file==NULL)
fatal("! Cannot open output file:",output_file_name);

printf("\n(%s)",output_file_name);update_terminal;
cur_line= 1;
stack_ptr= stack+1;
cur_name= (*an_output_file);
cur_repl= (text_pointer)cur_name->equiv;
cur_byte= cur_repl->tok_start;
cur_end= (cur_repl+1)->tok_start;
while(stack_ptr>stack)get_output();
flush_buffer();
}



/*:44*/
#line 625 "ctangle.w"

if(show_happiness)printf("\nDone.");
}
}



/*:43*//*47:*/
#line 700 "ctangle.w"

void out_char(cur_char)
eight_bits cur_char;
{
char*j;
switch(cur_char){
case'\n':if(protect)C_putc(' ');
if(protect||out_state==verbatim)C_putc('\\');
flush_buffer();if(out_state!=verbatim)out_state= misc;break;
/*49:*/
#line 747 "ctangle.w"

case identifier:
if(out_state==num_or_id)C_putc(' ');
for(j= (cur_val+name_dir)->byte_start;j<(name_dir+cur_val+1)->byte_start;
j++)C_putc(*j);
out_state= num_or_id;break;



/*:49*/
#line 709 "ctangle.w"

/*50:*/
#line 757 "ctangle.w"

case module_number:
if(cur_val>0)C_printf("/*%d:*/",cur_val);
else if(cur_val<0)C_printf("/*:%d*/",-cur_val);
else{
sixteen_bits a;
a= 0400**cur_byte++;
a+= *cur_byte++;
C_printf("\n#line %d \"",a);
cur_val= *cur_byte++;
cur_val= 0400*(cur_val-0200)+*cur_byte++;
for(j= (cur_val+name_dir)->byte_start;j<(name_dir+cur_val+1)->byte_start;
j++)C_putc(*j);
C_printf("\"\n",0);
}
break;





/*:50*/
#line 710 "ctangle.w"

/*48:*/
#line 731 "ctangle.w"

case plus_plus:C_putc('+');C_putc('+');out_state= misc;break;
case minus_minus:C_putc('-');C_putc('-');out_state= misc;break;
case minus_gt:C_putc('-');C_putc('>');out_state= misc;break;
case gt_gt:C_putc('>');C_putc('>');out_state= misc;break;
case eq_eq:C_putc('=');C_putc('=');out_state= misc;break;
case lt_lt:C_putc('<');C_putc('<');out_state= misc;break;
case gt_eq:C_putc('>');C_putc('=');out_state= misc;break;
case lt_eq:C_putc('<');C_putc('=');out_state= misc;break;
case not_eq:C_putc('!');C_putc('=');out_state= misc;break;
case and_and:C_putc('&');C_putc('&');out_state= misc;break;
case or_or:C_putc('|');C_putc('|');out_state= misc;break;



/*:48*/
#line 711 "ctangle.w"

case'=':C_putc('=');if(out_state!=verbatim){
C_putc(' ');out_state= misc;
}
break;
case join:out_state= unbreakable;break;
case constant:if(out_state==verbatim){
out_state= num_or_id;break;
}
if(out_state==num_or_id)C_putc(' ');out_state= verbatim;break;
case string:if(out_state==verbatim)out_state= misc;
else out_state= verbatim;break;
default:C_putc(cur_char);if(out_state!=verbatim)out_state= misc;
break;
}
}



/*:47*//*54:*/
#line 835 "ctangle.w"

eight_bits skip_ahead()
{eight_bits c;

while(true){
if(loc>limit&&(get_line()==0))return new_module;
*(limit+1)= '@';
while(*loc!='@')loc++;
if(loc<=limit){
loc++;c= ccode[*loc];loc++;
if(c!=ignore||*(loc-1)=='>')return c;
}
}
}



/*:54*//*56:*/
#line 865 "ctangle.w"

boolean skip_comment()
{char c;

while(true){
if(loc>limit)
if(get_line())
return(comment_continues= true);
else{
err_print("! Input ended in mid-comment");

return(comment_continues= false);
}
c= *loc++;
if(c=='*'&&*loc=='/'){
loc++;
return(comment_continues= false);
}
if(c=='@'){
if(ccode[*loc]==new_module){
err_print("! Section name ended in mid-comment");loc--;

return(comment_continues= false);
}
else loc++;
}
}
}





/*:56*//*58:*/
#line 910 "ctangle.w"

eight_bits get_next()
{
static int preprocessing= 0;
eight_bits c;

while(true){
if(loc>limit){
if(preprocessing&&*(limit-1)!='\\')preprocessing= 0;
if(get_line()==0)
return new_module;
else if(print_where){
print_where= 0;
/*72:*/
#line 1242 "ctangle.w"

{store_two_bytes(0150000);

if(changing)
id_first= change_file_name;
else id_first= cur_file_name;

id_loc= id_first+strlen(id_first);

if(changing)
store_two_bytes((sixteen_bits)change_line);
else store_two_bytes((sixteen_bits)cur_line);

{int a= id_lookup(id_first,id_loc)-name_dir;

app_repl((a/0400)+0200);app_repl(a%0400);
}
}



/*:72*/
#line 923 "ctangle.w"

}
else return'\n';
}
c= *loc;
if(comment_continues||(c=='/'&&*(loc+1)=='*')){
if(skip_comment())
return'\n';
else continue;
}
loc++;
if(isdigit(c)||c=='\\'||c=='.')/*61:*/
#line 986 "ctangle.w"

{id_first= loc-1;
if(*id_first=='.'&&!isdigit(*loc))goto mistake;
if(*id_first=='\\')while(isdigit(*loc))loc++;
else{
if(*id_first=='0'){
if(*loc=='x'||*loc=='X'){
loc++;while(isxdigit(*loc))loc++;goto found;
}
}
while(isdigit(*loc))loc++;
if(*loc=='.'){
loc++;
while(isdigit(*loc))loc++;
}
if(*loc=='e'||*loc=='E'){
if(*++loc=='+'||*loc=='-')loc++;
while(isdigit(*loc))loc++;
}
}
found:if(*loc=='l'||*loc=='L')loc++;
id_loc= loc;
return constant;
}



/*:61*/
#line 934 "ctangle.w"

else if(isalpha(c)||c=='_')/*60:*/
#line 976 "ctangle.w"

{id_first= --loc;
while(isalpha(*++loc)||isdigit(*loc)||*loc=='_');
id_loc= loc;
return identifier;
}



/*:60*/
#line 935 "ctangle.w"

else if(c=='\''||c=='\"')/*62:*/
#line 1018 "ctangle.w"
{
char delim= c;
id_first= mod_text+1;
id_loc= mod_text;*++id_loc= delim;

while(true){
if(loc>=limit){
if(*(limit-1)!='\\'){
err_print("! String didn't end");loc= limit;break;

}
if(get_line()==0){
err_print("! Input ended in middle of string");loc= buffer;break;

}
else if(++id_loc<=mod_text_end)*id_loc= '\n';

}
if((c= *loc++)==delim){
if(++id_loc<=mod_text_end)*id_loc= c;
break;
}
if(c=='\\'){
if(loc>=limit)continue;
if(++id_loc<=mod_text_end)*id_loc= '\\';
c= *loc++;
}
if(++id_loc<=mod_text_end)*id_loc= c;
}
if(id_loc>=mod_text_end){
printf("\n! String too long: ");

term_write(mod_text+1,25);
err_print("...");
}
id_loc++;
return string;
}



/*:62*/
#line 936 "ctangle.w"

else if(c=='@')/*63:*/
#line 1062 "ctangle.w"
{
c= ccode[*loc++];
switch(c){
case ignore:continue;
case control_text:while((c= skip_ahead())=='@');

if(*(loc-1)!='>')err_print("! Improper @ within control text");

continue;
case module_name:
cur_module_char= *(loc-1);
/*65:*/
#line 1099 "ctangle.w"

{char*k;

/*67:*/
#line 1125 "ctangle.w"

k= mod_text;
while(true){
if(loc>limit&&get_line()==0){
err_print("! Input ended in section name");

loc= buffer+1;break;
}
c= *loc;
/*68:*/
#line 1152 "ctangle.w"

if(c=='@'){
c= *(loc+1);
if(c=='>'){
loc+= 2;break;
}
if(ccode[c]==new_module){
err_print("! Section name didn't end");break;

}
*++k= '@';loc++;
}



/*:68*/
#line 1134 "ctangle.w"

loc++;if(k<mod_text_end)k++;
if(isspace(c)){
c= ' ';if(*(k-1)==' ')k--;
}
*k= c;
}
if(k>=mod_text_end){
printf("\n! Section name too long: ");

term_write(mod_text+1,25);
printf("...");mark_harmless;
}
if(*k==' '&&k>mod_text)k--;



/*:67*/
#line 1102 "ctangle.w"

if(k-mod_text>3&&strncmp(k-2,"...",3)==0)cur_module= prefix_lookup(mod_text+1,k-3);
else cur_module= mod_lookup(mod_text+1,k);
if(cur_module_char=='(')
/*41:*/
#line 579 "ctangle.w"

{if(cur_out_file>output_files){
for(an_output_file= cur_out_file;
an_output_file<end_output_files;an_output_file++)
if(*an_output_file==cur_module)
break;
if(an_output_file==end_output_files)
*--cur_out_file= cur_module;
}else{
overflow("output files");
}
}





/*:41*/
#line 1107 "ctangle.w"

return module_name;
}



/*:65*/
#line 1073 "ctangle.w"

case string:/*69:*/
#line 1172 "ctangle.w"

{id_first= loc++;*(limit+1)= '@';*(limit+2)= '>';
while(*loc!='@'||*(loc+1)!='>')loc++;
if(loc>=limit)err_print("! Verbatim string didn't end");

id_loc= loc;loc+= 2;
return string;
}





/*:69*/
#line 1074 "ctangle.w"

case ord:/*64:*/
#line 1083 "ctangle.w"

id_first= loc;
if(*loc=='\\')loc++;
while(*loc!='\''){
loc++;
if(loc>limit){
err_print("! String didn't end");loc= limit-1;break;

}
}
loc++;
return ord;



/*:64*/
#line 1075 "ctangle.w"

default:return c;
}
}



/*:63*/
#line 937 "ctangle.w"

else if(isspace(c)){
if(!preprocessing||loc>limit)continue;

else return' ';
}
else if(c=='#'&&loc==buffer+1)preprocessing= 1;
mistake:/*59:*/
#line 958 "ctangle.w"

switch(c){
case'+':if(*loc=='+')compress(plus_plus);break;
case'-':if(*loc=='-'){compress(minus_minus);}
else if(*loc=='>')compress(minus_gt);break;
case'=':if(*loc=='=')compress(eq_eq);break;
case'>':if(*loc=='='){compress(gt_eq);}
else if(*loc=='>')compress(gt_gt);break;
case'<':if(*loc=='='){compress(lt_eq);}
else if(*loc=='<')compress(lt_lt);break;
case'&':if(*loc=='&')compress(and_and);break;
case'|':if(*loc=='|')compress(or_or);break;
case'!':if(*loc=='=')compress(not_eq);break;
}



/*:59*/
#line 944 "ctangle.w"

return c;
}
}



/*:58*//*71:*/
#line 1211 "ctangle.w"

void scan_repl(t)
eight_bits t;
{sixteen_bits a;

if(t==module_name)
/*72:*/
#line 1242 "ctangle.w"

{store_two_bytes(0150000);

if(changing)
id_first= change_file_name;
else id_first= cur_file_name;

id_loc= id_first+strlen(id_first);

if(changing)
store_two_bytes((sixteen_bits)change_line);
else store_two_bytes((sixteen_bits)cur_line);

{int a= id_lookup(id_first,id_loc)-name_dir;

app_repl((a/0400)+0200);app_repl(a%0400);
}
}



/*:72*/
#line 1217 "ctangle.w"


while(true)
switch(a= get_next()){
/*73:*/
#line 1264 "ctangle.w"

case identifier:a= id_lookup(id_first,id_loc)-name_dir;app_repl((a/0400)+0200);
app_repl(a%0400);break;
case module_name:if(t!=module_name)goto done;
else{
/*74:*/
#line 1290 "ctangle.w"

{char*try_loc= loc;

while(*try_loc==' '&&try_loc<limit)try_loc++;
if(*try_loc=='+'&&try_loc<limit)try_loc++;
while(*try_loc==' '&&try_loc<limit)try_loc++;
if(*try_loc=='=')err_print("! Missing `@ ' before a named module");

}



/*:74*/
#line 1269 "ctangle.w"

a= cur_module-name_dir;
app_repl((a/0400)+0250);
app_repl(a%0400);
/*72:*/
#line 1242 "ctangle.w"

{store_two_bytes(0150000);

if(changing)
id_first= change_file_name;
else id_first= cur_file_name;

id_loc= id_first+strlen(id_first);

if(changing)
store_two_bytes((sixteen_bits)change_line);
else store_two_bytes((sixteen_bits)cur_line);

{int a= id_lookup(id_first,id_loc)-name_dir;

app_repl((a/0400)+0200);app_repl(a%0400);
}
}



/*:72*/
#line 1273 "ctangle.w"

break;
}
case constant:case string:
/*75:*/
#line 1303 "ctangle.w"

app_repl(a);
while(id_first<id_loc){
if(*id_first=='@'){
if(*(id_first+1)=='@')id_first++;
else err_print("! Double @ should be used in strings");

}
app_repl(*id_first++);
}
app_repl(a);break;



/*:75*/
#line 1277 "ctangle.w"

case ord:
/*76:*/
#line 1322 "ctangle.w"

{int c= *id_first;

if(c=='@'){
if(*(id_first+1)!='@')err_print("! Double @ should be used in strings");

else id_first++;
}
else if(c=='\\'){
c= *++id_first;
switch(c){
case't':c= '\t';break;
case'n':c= '\n';break;
case'b':c= '\b';break;
case'f':c= '\f';break;
case'v':c= '\v';break;
case'r':c= '\r';break;
case'0':c= '\0';break;
case'\\':c= '\\';break;
case'\'':c= '\'';break;
case'\"':c= '\"';break;
default:err_print("! Unrecognized escape sequence");

}
}

app_repl(constant);
if(c>=100)app_repl(c/100);
if(c>=10)app_repl((c/10)%10);
app_repl(c%10);
app_repl(constant);
}
break;





/*:76*/
#line 1279 "ctangle.w"

case definition:case format:case begin_C:if(t!=module_name)goto done;
else{
err_print("! @d, @f and @c are ignored in C text");continue;

}
case new_module:goto done;



/*:73*/
#line 1225 "ctangle.w"

default:app_repl(a);
break;
}
done:next_control= (eight_bits)a;
if(text_ptr>text_info_end)
overflow("text");

cur_text= text_ptr;(++text_ptr)->tok_start= tok_ptr;
}



/*:71*//*78:*/
#line 1372 "ctangle.w"

void scan_module()
{name_pointer p;
text_pointer q;
sixteen_bits a;

module_count++;
if(*(loc-1)=='*'&&show_progress){
printf("*%d",module_count);update_terminal;
}
/*79:*/
#line 1389 "ctangle.w"

{next_control= 0;

while(true){
while(next_control<=format)
if((next_control= skip_ahead())==module_name){

loc-= 2;next_control= get_next();
}
if(next_control!=definition)
break;
while((next_control= get_next())=='\n')
continue;
if(next_control!=identifier){
err_print("! Definition flushed, must start with identifier");

continue;
}
app_repl(((a= id_lookup(id_first,id_loc)-name_dir)/0400)
+0200);
app_repl(a%0400);
if(*loc!='('){

app_repl(string);app_repl(' ');app_repl(string);
}
print_where= 0;scan_repl(macro);
cur_text->text_link= 0;
}
}



/*:79*/
#line 1382 "ctangle.w"

/*80:*/
#line 1422 "ctangle.w"

{switch(next_control){
case begin_C:p= name_dir;
break;
case module_name:p= cur_module;
/*81:*/
#line 1441 "ctangle.w"

while((next_control= get_next())=='+');
if(next_control!='='&&next_control!=eq_eq){
err_print("! C text flushed, = sign is missing");

while((next_control= skip_ahead())!=new_module)
continue;
return;
}



/*:81*/
#line 1428 "ctangle.w"

break;
default:return;
}
/*82:*/
#line 1454 "ctangle.w"

store_two_bytes((sixteen_bits)(0150000+module_count));




/*:82*/
#line 1432 "ctangle.w"

scan_repl(module_name);

/*83:*/
#line 1461 "ctangle.w"

{if(p==name_dir||p==0){
last_unnamed->text_link= cur_text-text_info;
last_unnamed= cur_text;
}else if(p->equiv==(void*)text_info)
p->equiv= (void*)cur_text;
else{
q= (text_pointer)p->equiv;
while(q->text_link<module_flag)
q= q->text_link+text_info;
q->text_link= cur_text-text_info;
}
cur_text->text_link= module_flag;

}



/*:83*/
#line 1435 "ctangle.w"

}



/*:80*/
#line 1383 "ctangle.w"

}



/*:78*//*85:*/
#line 1484 "ctangle.w"

void phase_one()
{phase= 1;module_count= 0;reset_input();

while((next_control= skip_ahead())!=new_module)
continue;

while(!input_has_ended)
scan_module();

check_complete();
}



/*:85*//*86:*/
#line 1500 "ctangle.w"

#ifdef STAT
void print_stats()
{printf("\nMemory usage statistics:\n");
printf("%d names (out of %d)\n",name_ptr-name_dir,max_names);
printf("%d replacement texts (out of %d)\n",text_ptr-text_info,
max_textmem);
printf("%d bytes (out of %d)\n",byte_ptr-byte_mem,max_bytes);
printf("%d tokens (out of %d)\n",tok_ptr-tok_mem,max_tokmem);
}
#endif





/*:86*/
