#
# Public Release 3
# 
# $Id: sigconv.awk,v 1.2 1997/07/17 22:46:35 chopps Exp $
#
# ------------------------------------------------------------------------
# 
# Copyright (c) 1996, 1997 The Regents of the University of Michigan
# All Rights Reserved
#  
# Royalty-free licenses to redistribute GateD Release
# 3 in whole or in part may be obtained by writing to:
# 
# 	Merit GateDaemon Project
# 	4251 Plymouth Road, Suite C
# 	Ann Arbor, MI 48105
#  
# THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
# UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
# FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
# THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
# University of Michigan and Merit shall not be liable for
# any special, indirect, incidental or consequential damages with respect
# to any claim by Licensee or any third party arising from use of the
# software. GateDaemon was originated and developed through release 3.0
# by Cornell University and its collaborators.
# 
# Please forward bug fixes, enhancements and questions to the
# gated mailing list: gated-people@gated.merit.edu.
# 
# ------------------------------------------------------------------------
# 
# Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
#     All rights reserved.
# 
# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
# LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE.
# 
# GateD is based on Kirton's EGP, UC Berkeley's routing
# daemon	 (routed), and DCN's HELLO routing Protocol.
# Development of GateD has been supported in part by the
# National Science Foundation.
# 
# ------------------------------------------------------------------------
# 
# Portions of this software may fall under the following
# copyrights:
# 
# Copyright (c) 1988 Regents of the University of California.
# All rights reserved.
# 
# Redistribution and use in source and binary forms are
# permitted provided that the above copyright notice and
# this paragraph are duplicated in all such forms and that
# any documentation, advertising materials, and other
# materials related to such distribution and use
# acknowledge that the software was developed by the
# University of California, Berkeley.  The name of the
# University may not be used to endorse or promote
# products derived from this software without specific
# prior written permission.  THIS SOFTWARE IS PROVIDED
# ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
# INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
#
BEGIN {
  nsig = 0;
  max_sig = 0;
  last_sig = 0;
}

/^#define/ {
  if (NF < 3) {
    next;
  }
  sig = $3 + 0;
  if (sig != 0) {
    if ($2 == "NSIG" || $2 == "_NSIG") {
      if (nsig && sig != nsig) {
        print "#error Confliciting definitions of NSIG/SIGMAX"
      }
      nsig = sig;
    } else if ($2 == "SIGMAX" || $2 == "MAXSIG") {
      sig++;
      if (nsig && sig != nsig) {
        print "#error Confliciting definitions of NSIG/SIGMAX"
      }
      nsig = sig;
    } else if ( (substr($2,1,3) == "SIG") && (substr($2,4,1) != "_") ) {
      if (sig != last_sig) {
        last_sig = sig;
        signals[sig] = $2;
      }
    }
  }
}

END {
#  if (!nsig) {
#  	print "#error Could not find the definition of NSIG or SIGMAX!"
#  }
  if (last_sig > nsig) {
    last_sig = nsig - 1;
  }
  printf "/* This file was automatically generated by the awk script \"sigconv.awk\".*/\n\n"
  printf "#define INCLUDE_SIGNAL\n#include \"include.h\"\n\n"
  printf "const char *const sys_signame[] = {\t/* %s */\n", nsig ;
  printf "\t\"nal 0\",\n" ;
  for (sig = 1; sig <= last_sig; sig++) {
    if (length(signals[sig])) {
      printf "#ifdef\t%s\n", signals[sig]
      printf "\t\"%s\",\t/* %s */\n", \
       substr(signals[sig], 4), sig
      printf "#else\t/* %s */\n", signals[sig]
    }
    printf "\t\"nal %d\",\n", sig
    if (length(signals[sig])) {
      printf "#endif\t/* %s */\n", signals[sig]
    }
  }
  printf "};\n" ;
}
