
/*
 * seq_save.c -- 1) synchronize sequences
 *            -- 2) save public sequences
 *
 * $Id$
 */

#include <h/mh.h>
#include <h/signals.h>


/*
 * 1.  If sequence is public and folder is readonly,
 *     then change it to be private
 * 2a. If sequence is public, then add it to the sequences
 *     file in folder
 * 2b. If sequence is private, then add it to the
 *     context file.
 */

void
seq_save (struct msgs *mp)
{
    int i;
    char flags, *cp, attr[BUFSIZ], seq[BUFSIZ * 2];
    FILE *fp;
    sigset_t set, oset;

    if (!(mp->msgflags & SEQMOD))
	return;
    mp->msgflags &= ~SEQMOD;

    m_getdefs ();
    sprintf (seq, "%s/%s", mp->foldpath, mh_seq);
    fp = NULL;

    flags = mp->msgflags;
    if (mh_seq == NULL || *mh_seq == 0)
	mp->msgflags |= READONLY;

    for (i = 0; mp->msgattrs[i]; i++) {
	sprintf (attr, "atr-%s-%s", mp->msgattrs[i], mp->foldpath);
	if (mp->msgflags & READONLY || is_seq_private (mp, i)) {
priv:;
	    /*
	     * handle private sequences
	     */
	    if ((cp = seq_list(mp, mp->msgattrs[i])))
		m_replace (attr, cp);	/* update sequence in context   */
	    else
		m_delete (attr);	/* delete sequence from context */
	} else {
	    /*
	     * handle public sequences
	     */
	    m_delete (attr);		/* delete sequence from context */
	    if (!(cp = seq_list(mp, mp->msgattrs[i])))
		continue;
	    if (!fp) {
		if ((fp = fopen (seq, "w")) == NULL
			&& (unlink (seq) == NOTOK ||
			    (fp = fopen (seq, "w")) == NULL)) {
		    admonish (attr, "unable to write");
		    goto priv;
		}
		sigemptyset (&set);
		sigaddset(&set, SIGHUP);
		sigaddset(&set, SIGINT);
		sigaddset(&set, SIGQUIT);
		sigaddset(&set, SIGTERM);
		SIGPROCMASK (SIG_BLOCK, &set, &oset);
	    }
	    fprintf (fp, "%s: %s\n", mp->msgattrs[i], cp);
	}
    }

    if (fp) {
	fclose (fp);
	SIGPROCMASK (SIG_SETMASK, &oset, &set);  /* reset signal mask */
    } else {
	if (!(mp->msgflags & READONLY))
	    unlink (seq);
    }

    mp->msgflags = flags;
}
