
/*
 * pidstatus.c -- report child's status
 *
 * $Id$
 */

#include <h/mh.h>

/*
 * generated header
 */
#include <sigmsg.h>

#ifdef HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif

#ifndef WTERMSIG
# define WTERMSIG(s) ((int)((s) & 0x7f))
#endif

#ifndef WCOREDUMP
# define WCOREDUMP(s) ((s) & 0200)
#endif

int
pidstatus (int status, FILE *fp, char *cp)
{
    int signum;

    if ((status & 0xff00) == 0xff00)
	return status;

    signum = WTERMSIG(status);

    switch (signum) {
	case OK: 
	    if ((signum = ((status & 0xff00) >> 8))) {
		if (cp)
		    fprintf (fp, "%s: ", cp);
		fprintf (fp, "exit %d\n", signum);
	    }
	    break;

	case SIGINT: 
	    break;

	default: 
	    if (cp)
		fprintf (fp, "%s: ", cp);
	    if (signum >= sizeof(sigmsg) || sigmsg[signum] == NULL)
		fprintf (fp, "signal %d", signum);
	    else
		fprintf (fp, "%s", sigmsg[signum]);
	    fprintf (fp, "%s\n", WCOREDUMP(status) ? " (core dumped)" : "");
	    break;
    }

    return status;
}
