/*
**
** Copyright (C) 1994 Swedish University Network (SUNET)
**
**
** This program is developed by UDAC, Uppsala University by commission
** of the Swedish University Network (SUNET). 
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITTNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
**
**                                        Martin.Wendel@udac.uu.se
**                                        Torbjorn.Wictorin@udac.uu.se
**
**                                        UDAC	
**                                        P.O. Box 174
**                                        S-751 04 Uppsala
**                                        Sweden
**
*/


#include "emil.h"

void	encode_mailtool(struct message *m)
{
  char buf[HDRLEN];
  if (m->sd->format == MAILTOOL &&
      m->sd == m->td)
    return;
  if (m->level == 0)
    {
      if (match(m->type, "TEXT"))
	{
	  add_header(m, "Content-Type", "text", MAILTOOL);
	  sprintf(buf, "%d", get_body_lines(m->td));
	  add_header(m, "X-lines", buf, MAILTOOL); 
	}
      else
	{
	  add_header(m, "Content-Type", "X-Sun-Attachment", MAILTOOL);
	  m->td->startbound = NEWSTR("----------");
	}
    }
  else
    {
      if (m->td->encoding == EMULTI)
	{
	  m->td->startbound = NEWSTR("----------");
	  return;
	}
      if (match(m->type, "TEXT"))
	{
	  add_header(m, "X-Sun-Data-Type", "text", MAILTOOL);
	}
      else
      if (match(m->type, "APPLICATION"))
	{
	  add_header(m, "X-Sun-Data-Type", "default-app", MAILTOOL);
	}
      else
      if (match(m->type, "GIF"))
	{
	  add_header(m, "X-Sun-Data-Type", "gif-file", MAILTOOL);
	}
      else
      if (match(m->type, "ULAW"))
	{
	  add_header(m, "X-Sun-Data-Type", "audio-file", MAILTOOL);
	}
      else
	{
	  add_header(m, "X-Sun-Data-Type", "default", MAILTOOL);
	}
      switch (m->td->encoding) {
      case EUUENCODE:
	add_header(m, "X-Sun-Encoding-Info", "uuencode", MAILTOOL);
	break;
      case EBINHEX:
	add_header(m, "X-Sun-Encoding-Info", "binhex", MAILTOOL);
	break;
      case EBASE64:
	add_header(m, "X-Sun-Encoding-Info", "base64", MAILTOOL);
	break;
      }
      if (m->description != NULL)
	add_header(m, "X-Sun-Data-description", m->description, MAILTOOL);
      else
	add_header(m, "X-Sun-Data-description", "default", MAILTOOL);
      
      if (m->name != NULL)
	add_header(m, "X-Sun-Data-name", m->name, MAILTOOL);

      sprintf(buf, "%d", get_body_lines(m->td));
      add_header(m, "X-Sun-Content-lines", buf, MAILTOOL);
    }
}

int decode_mailtool(struct message *m)
{
  if (m->level == 0)
    {
      if (matchheader(m, "Content-Type", "text", MAILTOOL))
	{
	  m->sd->format = MAILTOOL;
	  m->type = NEWSTR("TEXT");
	  m->sd->encoding = E7BIT;
	  m->sd->charset = (char *)gethval(m, "X-Sun-charset", MAILTOOL);
	}
      else
      /* Look for SUN Mailtool */
      if (matchheader(m, "Content-Type", "X-Sun-Attachment", MAILTOOL))
	    {
	      m->sd->format = MAILTOOL;
	      m->type = NEWSTR("MULTIPART");
	      m->sd->check = EMULTI;
	      m->sd->encoding = EMULTI;
	      m->sd->startbound = NEWSTR("----------");
	    }

      if (m->sd->format == MAILTOOL)
	{
	  m->sd->length = string2dec(gethval(m, "Content-length", MAILTOOL));
	  m->sd->bodylines = string2dec(gethval(m, "X-lines", MAILTOOL));
	  return(OK);
	}
      else
	return(NOK);
    }
  /**
   ** This is valid for SUN Mailtool message, except for root header 
   **/

  if (m->sd->format == MAILTOOL && m->level != 0)
    {
      /* Not complete or correct */
      if (matchheader(m, "X-Sun-Data-Type", "text", MAILTOOL))
	{
	  m->type = NEWSTR("TEXT");
	  m->sd->charset = "ISO-8859-1";
	  m->sd->encoding = E7BIT;
	}
      else
      if (matchheader(m, "X-Sun-Data-Type", "default-app", MAILTOOL))
	{
	  m->type = NEWSTR("APPLICATION");
	}
      else
      if (matchheader(m, "X-Sun-Data-Type", "default-app", MAILTOOL))
	{
	  m->type = NEWSTR("APPLICATION");
	}
      else
      if (matchheader(m, "X-Sun-Data-Type", "gif-file", MAILTOOL))
	{
	  m->type = NEWSTR("GIF");
	}
      else
      if (matchheader(m, "X-Sun-Data-Type", "audio-file", MAILTOOL))
	{
	  m->type = NEWSTR("ULAW");
	}
      else
	m->type = NEWSTR("APPLICATION");

      if (matchheader(m, "X-Sun-Encoding-Info", "uuencode", MAILTOOL))
	{
	  m->sd->encoding = EUUENCODE;
	}
      else
      if (matchheader(m, "X-Sun-Encoding-Info", "binhex", MAILTOOL))
	{
	  m->sd->encoding = EBINHEX;
	}
      else
      if (matchheader(m, "X-Sun-Encoding-Info", "base64", MAILTOOL))
	{
	  m->sd->encoding = EBASE64;
	}

	
      m->sd->length = string2dec(gethval(m, "X-Sun-Content-length", MAILTOOL));
      m->sd->bodylines = string2dec(gethval(m, "X-Sun-Content-lines", MAILTOOL));
      m->description = (char *)gethval(m, "X-Sun-Data-description", MAILTOOL);
      m->name = (char *)gethval(m, "X-Sun-Data-name", MAILTOOL);
    }  
  else
    return (NOK);
  return (OK);
}

int
get_body_lines(struct data *d)
{
  char *c;
  int i, e, l;
  
  l = 0;
  i = d->bodystart;
  e = d->bodyend;
  c = d->contents + i;
  for (; i < e; i++, c++)
    if (*c == '\n')
      l++;
  return(l);
}
