/*
 * 
 *  Master C file illustrating a particular foundation for GUI control
 *
 *  COPYRIGHT
 *	Michael K. Ganley
 *	mikegan@world.std.com
 *  31 August 1995
 *
 *
 */

#include <string.h>
#include <stdio.h>
#include <tcl.h>
#include <tk.h>
#include "inc_hdr.h"
#include "msg.h"
#include "hello.h"

/* GLOBALS */
static int			alive = 1;
int					Qid;



int main(int argc, char *argv[], char *envp[])
{

/*
 *  Linked variables
 */
int					windowup;
int					messageFlag;

/*
 *  Msg variables (that are not global)
 */

GuiMessage 			guimsg;
int 				retcode;

/*
 *  Main window variables
 */

Tk_Window 			mainWindow;
Tcl_Interp 			*interp;
static char     	*display = NULL;

/*
 *	Misc
 */
short				err = 0;
long				i;



/* 
 *  CODE begins
 */

/* 
 *  Ready the message Queue for C-program to poll
 */

Qid = msgget( GUI_MSG_QKEY, IPC_CREAT | PERMISSION );
if( Qid < 0 )
	{
	fprintf( stderr, "\nError with message Queue." );
	exit( 1 );
	}

/*
 *   Create the interpreter and main toplevel window
 */

interp = Tcl_CreateInterp();

mainWindow = Tk_CreateMainWindow( interp, display, "Ganley's Example", "Tk" );

Tk_GeometryRequest( mainWindow, 400, 300 );
Tk_SetWindowBorderWidth( mainWindow, 0 );
Tk_MoveResizeWindow( mainWindow, 5, 5, 400, 400 );


if( Tcl_Init(interp) == TCL_ERROR ) 
	{
	fprintf(stderr, "Tcl_Init failed: %s\n", interp->result);
	exit(1);
	}

if( Tk_Init(interp) == TCL_ERROR ) 
	{
	fprintf(stderr, "Tk_Init failed: %s\n", interp->result);
	exit(1);
	}

/*
 *   Personal New Commands to register
 */

Tcl_CreateCommand(interp, "sendToQ", sendToQCmd,
 			(ClientData) NULL, (void (*) ()) NULL);

Tcl_CreateCommand( interp, "getDateTime", getDateTimeCmd,
			(ClientData) NULL, (void (*) ()) NULL);


/*
 *   Link the variables to be shared between C and the script
 */

Tcl_LinkVar(interp, "winup", (char *) &windowup, TCL_LINK_INT);
Tcl_LinkVar(interp, "msgFlag", (char *) &messageFlag, TCL_LINK_INT);

/*
 *   Evaluate the script to get the GUI running
 */

retcode = Tcl_EvalFile( interp, argv[1] );

if ( retcode != TCL_OK )
 	{
	fprintf( stderr, "\nGUI: Initialization ERROR: " );
    fprintf( stderr, "%s\n", interp->result );
    exit(1);
 	}


/*
 *   Call Tcl_SetVar with the Linked Variables as an argument
 */

Tcl_SetVar( interp, "winup", "0", TCL_GLOBAL_ONLY );
Tcl_SetVar( interp, "msgFlag", "0", TCL_GLOBAL_ONLY );
windowup = 0;
messageFlag = 0;	 


/*
 *  Start of EVENT loop ********
 */

do  {

	/*
	 *	Process Tcl/Tk script events
	 */
	
	Tk_DoOneEvent(0);

	/*
	 *  Check shared variable and perform special processing
	 */

	switch( windowup )
		{

		case 99:

			alive = 0;

			break;

		}

	/*
	 *  Start Message processing
	 */

	retcode = msgrcv( Qid, ( struct msgbuf *) &guimsg,
	  	sizeof( guimsg ) - sizeof( long ), -2, IPC_NOWAIT | MSG_NOERROR );

	if( retcode < 0 && errno == ENOMSG )
		{
		/*  NO MESSAGE  */
		}
	else
		{
		/*  MESSAGE     */

 		err = 0;

		switch( guimsg.msg_type )
			{

			case MSG_TYPE1:
				
				fprintf( stderr, "\n Message received: var = %d ",
					guimsg.core.msg1.var );
				messageFlag = 1;

				break;


			case MSG_TYPE2:


				break;


			} 

		}
   

	}while( alive == 1 );


/*
 *  End of EVENT loop ***********
 */

/*
 *	Clean up leftovers
 */

msgctl( Qid, IPC_RMID, (struct msqid_ds * ) 0 );

/*
 *	Program has finished
 */

exit(1);

}



/* EOF */
