#==============================================================================
#                                  vwbk.tcl
#------------------------------------------------------------------------------
# Defines the VW back (trunk) surface.
#
# Copyright (c) Evans & Sutherland - ok to distribute if copyright appears.
#------------------------------------------------------------------------------
# $Id: vwbk.tcl,v 4.0 1993/11/27 21:25:30 markd Rel $
#==============================================================================

proc SippVWBack {side shader} {

    set pnt(1)  { 0.000   76.200   13.000}
    set pnt(2)  { 0.000   77.000    9.500}
    set pnt(3)  { 4.500   77.000    9.500}
    set pnt(4)  { 3.700   76.200   13.000}
    set pnt(5)  { 5.000   76.000   11.000}
    set pnt(6)  { 6.700   76.000   13.500}
    set pnt(7)  { 6.000   75.500   11.200}
    set pnt(8)  { 7.000   75.600   11.000}
    set pnt(9)  { 7.500   76.200    9.500}
    set pnt(10) { 9.400   74.500   15.000}
    set pnt(11) {12.000   72.500   17.000}
    set pnt(12) {14.500   75.200    9.750}
    set pnt(13) {14.200   69.500   19.400}
    set pnt(14) {15.000   70.000   18.500}
    set pnt(15) {15.100   68.000   20.500}
    set pnt(16) { 0.000   60.700   38.000}
    set pnt(17) { 6.300   60.500   37.700}
    set pnt(18) {12.000   60.000   36.500}
    set pnt(19) {17.000   58.000   34.000}
    set pnt(20) {17.000   58.000   34.000}
    set pnt(21) {18.500   57.600   33.200}
    set pnt(22) {19.600   58.000   30.800}
    set pnt(23) { 0.000   67.000   33.500}
    set pnt(24) { 6.500   65.200   33.000}
    set pnt(25) {12.200   63.500   32.400}
    set pnt(26) {15.800   62.500   30.000}
    set pnt(27) {15.800   62.500   30.000}
    set pnt(28) {17.500   62.000   29.300}
    set pnt(29) {18.500   61.000   28.000}
    set pnt(30) {11.500   69.700   27.200}
    set pnt(31) {13.500   67.700   24.800}
    set pnt(32) {13.500   67.700   24.800}
    set pnt(33) {15.500   66.700   24.000}
    set pnt(34) {16.500   66.000   22.700}
    set pnt(35) { 0.000   71.000   28.000}
    set pnt(36) { 2.500   71.000   27.800}
    set pnt(37) { 6.000   71.000   27.000}
    set pnt(38) { 6.700   71.500   26.000}
    set pnt(39) { 6.500   72.000   25.500}
    set pnt(40) { 9.500   71.700   24.500}
    set pnt(41) {11.500   70.500   21.800}
    set pnt(42) {11.500   70.500   21.800}
    set pnt(43) {13.000   70.500   21.000}
    set pnt(44) {14.200   69.500   19.400}
    set pnt(45) { 0.000   72.000   25.500}
    set pnt(46) { 7.500   72.500   21.500}
    set pnt(47) { 9.000   72.500   19.500}
    set pnt(48) { 9.200   72.500   19.500}
    set pnt(49) { 9.600   72.800   19.500}
    set pnt(50) { 9.800   72.800   19.500}
    set pnt(51) {11.000   72.800   18.500}
    set pnt(52) {12.000   72.500   17.000}
    set pnt(53) { 8.000   73.000   18.900}
    set pnt(54) { 8.200   73.100   18.800}
    set pnt(55) { 8.600   73.500   18.500}
    set pnt(56) { 8.700   73.500   18.400}
    set pnt(57) { 9.200   74.000   16.500}
    set pnt(58) { 9.400   74.500   15.000}
    set pnt(59) { 6.000   74.500   18.100}
    set pnt(60) { 6.200   74.600   18.000}
    set pnt(61) { 6.500   75.500   17.600}
    set pnt(62) { 6.600   75.600   17.500}
    set pnt(63) { 6.600   76.000   15.500}
    set pnt(64) { 6.700   76.000   13.500}
    set pnt(65) { 3.200   74.700   17.500}
    set pnt(66) { 3.300   74.800   17.400}
    set pnt(67) { 3.500   75.700   17.100}
    set pnt(68) { 3.600   75.800   17.000}
    set pnt(69) { 3.600   76.200   14.500}
    set pnt(70) { 3.700   76.200   13.000}
    set pnt(71) { 0.000   74.700   17.500}
    set pnt(72) { 0.000   74.800   17.400}
    set pnt(73) { 0.000   75.700   17.100}
    set pnt(74) { 0.000   75.800   17.000}
    set pnt(75) { 0.000   76.200   14.500}
    set pnt(76) { 0.000   76.200   13.000}
    set pnt(77) { 0.000   73.000   25.500}
    set pnt(78) { 6.000   73.000   25.500}
    set pnt(79) { 6.000   75.000   20.000}
    set pnt(80) { 0.000   75.000   20.000}
    set pnt(81) { 0.000   71.000   28.000}
    set pnt(82) { 2.500   71.000   27.800}
    set pnt(83) { 6.000   71.000   27.000}
    set pnt(84) { 6.700   71.500   26.000}
    set pnt(85) { 6.000   71.000   25.800}
    set pnt(86) { 4.600   72.000   25.800}
    set pnt(87) { 1.500   73.800   25.800}
    set pnt(88) { 0.000   74.000   25.800}
    set pnt(89) { 0.000   73.500   26.800}
    set pnt(90) { 2.000   73.000   26.800}
    set pnt(91) { 4.500   72.000   26.800}
    set pnt(92) { 5.300   71.000   26.800}
    set pnt(93) { 2.500   71.500   27.400}
    set pnt(94) { 0.000   72.500   27.600}
    set pnt(95) {15.100   68.000   20.500}

    SippVW:DefPoly $side pnt { 1   4   3   2}
    SippVW:DefPoly $side pnt { 4   5   3}
    SippVW:DefPoly $side pnt { 4   6   7   5}
    SippVW:DefPoly $side pnt { 6  10   8   7}
    SippVW:DefPoly $side pnt {10  11  12   9  8}
    SippVW:DefPoly $side pnt {11  13  14  12}
    SippVW:DefPoly $side pnt {13  15  14}
    SippVW:DefPoly $side pnt {16  17  24  23}
    SippVW:DefPoly $side pnt {17  18  25  24}
    SippVW:DefPoly $side pnt {18  19  26  25}
    SippVW:DefPoly $side pnt {20  21  28  27}
    SippVW:DefPoly $side pnt {21  22  29  28}
    SippVW:DefPoly $side pnt {23  24  36  35}
    SippVW:DefPoly $side pnt {36  24  37}
    SippVW:DefPoly $side pnt {24  25  30  37}
    SippVW:DefPoly $side pnt {25  26  31  30}
    SippVW:DefPoly $side pnt {27  28  33  32}
    SippVW:DefPoly $side pnt {28  29  34  33}
    SippVW:DefPoly $side pnt {37  30  38}
    SippVW:DefPoly $side pnt {38  30  40}
    SippVW:DefPoly $side pnt {30  31  41  40}
    SippVW:DefPoly $side pnt {32  33  43  42}
    SippVW:DefPoly $side pnt {33  34  44  43}
    SippVW:DefPoly $side pnt {35  36  45}
    SippVW:DefPoly $side pnt {45  36  37}
    SippVW:DefPoly $side pnt {45  37  38  39}
    SippVW:DefPoly $side pnt {45  39  65  71}
    SippVW:DefPoly $side pnt {65  39  59}
    SippVW:DefPoly $side pnt {39  46  59}
    SippVW:DefPoly $side pnt {39  40  46}
    SippVW:DefPoly $side pnt {59  46  53}
    SippVW:DefPoly $side pnt {53  46  47}
    SippVW:DefPoly $side pnt {46  40  41  47}
    SippVW:DefPoly $side pnt {47  42  48}
    SippVW:DefPoly $side pnt {48  42  49}
    SippVW:DefPoly $side pnt {49  42  50}
    SippVW:DefPoly $side pnt {42  43  51  50}
    SippVW:DefPoly $side pnt {43  44  52  51}
    SippVW:DefPoly $side pnt {47  48  54  53}
    SippVW:DefPoly $side pnt {48  49  55  54}
    SippVW:DefPoly $side pnt {49  50  56  55}
    SippVW:DefPoly $side pnt {50  51  57  56}
    SippVW:DefPoly $side pnt {51  52  58  57}
    SippVW:DefPoly $side pnt {53  54  60  59}
    SippVW:DefPoly $side pnt {54  55  61  60}
    SippVW:DefPoly $side pnt {55  56  62  61}
    SippVW:DefPoly $side pnt {56  57  63  62}
    SippVW:DefPoly $side pnt {57  58  64  63}
    SippVW:DefPoly $side pnt {59  60  66  65}
    SippVW:DefPoly $side pnt {60  61  67  66}
    SippVW:DefPoly $side pnt {61  62  68  67}
    SippVW:DefPoly $side pnt {62  63  69  68}
    SippVW:DefPoly $side pnt {63  64  70  69}
    SippVW:DefPoly $side pnt {65  66  72  71}
    SippVW:DefPoly $side pnt {66  67  73  72}
    SippVW:DefPoly $side pnt {67  68  74  73}
    SippVW:DefPoly $side pnt {68  69  75  74}
    SippVW:DefPoly $side pnt {69  70  76  75}
    SippVW:DefPoly $side pnt {77  78  79  80}
    SippVW:DefPoly $side pnt {81  82  93  94}
    SippVW:DefPoly $side pnt {94  93  90  89}
    SippVW:DefPoly $side pnt {89  90  87  88}
    SippVW:DefPoly $side pnt {82  83  92  93}
    SippVW:DefPoly $side pnt {93  92  91  90}
    SippVW:DefPoly $side pnt {83  84  85  92}
    SippVW:DefPoly $side pnt {92  85  86  91}
    SippVW:DefPoly $side pnt {91  86  87  90}
    SippVW:DefPoly $side pnt {34  95  44}

    SippSurfaceCreate $shader
}
