#==============================================================================
#                                torus.tcl
#------------------------------------------------------------------------------
# A port of SIPP demo program torustest.c to Tcl-SIPP.
#------------------------------------------------------------------------------
# $Id: torus.tcl,v 4.0 1993/11/27 21:25:59 markd Rel $
#------------------------------------------------------------------------------

if {[info commands DoRendering] == ""} {
    if [file exists ./demoutil.tlib] {
        loadlibindex ./demoutil.tlib
    } else {
        set demoutil [searchpath $auto_path demos/demoutil.tlib]
        if [lempty $demoutil] {
            error "Can't find \"demos/demoutil.tlib\" on auto_path"
        }
        loadlibindex $demoutil
    }
}
ParseDemoArgs

set SMALLRES 15
set BIGRES   40


SippLightSourceCreate { 1.0  1.0 1.0} {0.9 0.9 0.9} DIRECTION
SippLightSourceCreate {-1.0 -1.0 0.5} {0.4 0.4 0.4} DIRECTION

set shader [SippShaderBasic 0.5 0.6 0.2 {0.6 0.3 0.5}]

SippObjectAddSubobj WORLD [SippTorus 1.0 0.4 $BIGRES $SMALLRES $shader WORLD]

SippCameraParams STDCAMERA {4.0 0.0 4.5}  {0.5 0.0 0.0} {0.0 0.0 1.0} 0.4

DoRendering "torus"
