
puts stdout "***
*** WARNING: From theObjects-2.2 on, the interpreted version of this
***          package may differ in its behavior from the compiled
***          system in cases where 'uplevel' is used in method bodies.
***"

proc streq {s1 s2} {
  expr ![string compare $s1 $s2]
}

set system(_wincount) 0

proc anon {{root {}}} {
  global system

  if { $root == "." } {
    set root {}
  }
  return "$root._[incr system(_wincount)]"
}

## proc args {args}
##	Argument parsing routine. This parses the arguments found in "args"
##	in the next higher level into variables also set in the next higher
##	level. The procedure takes a list of option names and default values.
##
proc args {args} {
  global system

  upvar args arguments_raw
  set arguments $arguments_raw

  set window {}
  catch {set window [uplevel {set name}]}

  if { $window == "*" } {
    uplevel [list set name [anon]]
  } elseif { [string range $window 0 0] == "*" } {
    uplevel [list set name [anon [string range $window 1 end]]]
  }

  foreach i $args {
    uplevel [list set [lindex $i 0] [lindex $i 1]]
  }

  while { $arguments != {} } {
    set key [lindex $arguments 0]
    set value [lindex $arguments 1]
    set arguments [lrange $arguments 2 end]

    set found 0
    foreach s $args {
      if { "-[lindex $s 0]" == $key } {
	uplevel [list set [lindex $s 0] $value]
	set found 1
	break
      }
    }
    if { $found == 0 } {
      puts stderr "\n------------------------------------------------------"
      puts stderr "Unknown option: $key ($value)"
      puts stderr "  ** Args  $arguments"
      puts stderr "  ** Opts: $args"
      puts stderr "  ** Cmd:  [info level -1]"
      catch {puts stderr "        :  [info level -2]"}
      puts stderr ""
    }
  }
  return {}
}

#---------------------------------------------------------------------------
#
#	Old (Interpreted) Versions of the Object Handlers
#
#---------------------------------------------------------------------------

proc defobject {name {super {}} {slots {}}} {
  global _o:$name system

  if { $name != "vanilla-object" && $super == {} } {
    set super {vanilla-object}
  }

  if { $system(verbose) } {
    puts stdout "**-- Creating object $name {$super}"
  }

  foreach spec $slots {
    set _o:${name}([lindex $spec 0]) [lindex $spec 1]
  }

  if { [catch {set _o:$name()}] } {
    set _o:${name}() {}
  }
  foreach s $super {
    if { [lsearch [set _o:${name}()] $s] < 0 } {
      lappend _o:${name}() $s
    }
  }

  defmethod $name

  return $name
}

proc defmethod {name {method {}} {arguments {}} {body {}}} {
  global _o:$name

  if { [llength $name] > 1 } {
    set super [lrange $name 1 end]
    set name [lindex $name 0]
  } {
    set super {}
  }

  if { [info command ${name}] == "" } {
    proc $name {{method ""} args} "_method(interpret) $name \$method \$args"
    if { [catch {set _o:${name}()}] } {
      defobject $name $super
    }
  }

  if { $method != {} } {
    proc _method($name,$method) [concat {self} $arguments] $body
  }
  return $method
}

default system	trace	0
set system(tracelevel)	0

#    if { $system(trace) } {
#      set level $system(tracelevel)
#      incr system(tracelevel)
#      puts stdout "${level}>> $handler $name >> $arguments"
#      set res [eval [concat $handler $name $arguments]]
#      puts stdout "${level}<< $res"
#      set system(tracelevel) $level
#      return $res
#    }

proc _method(interpret) {name method arguments} {
  global system

  set handler [_method(find) $name $method]
  if { $handler != {} } {
    return [eval [concat $handler $name $arguments]]
  }

  if { $method != "DEFAULT" } {
    return [_method(interpret) $name DEFAULT \
		[concat [list $method] $arguments]]
  }

  error "Object '$name' doesn't handle message {$arguments}."
}

proc _method(find) {object method} {
  global _o:${object}

  if { [info command _method($object,$method)] != {} } {
    return _method($object,$method)
  }
  foreach super [set _o:${object}()] {
    set handler [_method(find) $super $method]
    if { $handler != {} } {
      return $handler
    }
  }
  return
}
