/*-
 * Copyright (c) 1993 Michael B. Durian.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Michael B. Durian.
 * 4. The name of the the Author may be used to endorse or promote 
 *    products derived from this software without specific prior written 
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * mdevice.h,v 1.5 1993/05/05 01:34:17 durian Exp
 */
#ifndef MDEVICE_H
#define MDEVICE_H

typedef enum {PLAY, RECORD, PLAYRECORD} PlayMode;

extern int play_tracks _ANSI_ARGS_((int dev, TCHUNK *tracks, int *indices,
    int num, int repeat));
extern int record_tracks _ANSI_ARGS_((int dev, TCHUNK *p_tracks, int *indices,
    int p_num, TCHUNK *r_track, int repeat));
extern int stop_processing _ANSI_ARGS_((int dev));
extern int open_midi_device _ANSI_ARGS_((PlayMode mode));
extern int init_midi_device _ANSI_ARGS_((int dev, HCHUNK *hd, double reltempo));
extern int start_midi_device _ANSI_ARGS_((int dev, PlayMode mode));
extern int stop_midi_device _ANSI_ARGS_((int dev, PlayMode mode));
extern int close_midi_device _ANSI_ARGS_((int dev));

#endif
