'\"
'\" Copyright 1994 D.I.S. \- Universita` di Pavia \- Italy
'\"
'\" Permission to  use,  copy,   modify,   distribute  this  software
'\" and  its  documentation for any purpose is hereby granted without
'\" fee, provided that the above copyright  notice   appear   in  all
'\" copies   and  that both that copyright notice and this permission
'\" notice appear in supporting documentation, and that the  name  of
'\" D.I.S.   not  be  used  in advertising or publicity pertaining to
'\" distribution of the software without specific, written prior per\-
'\" mission.   D.I.S.  makes no representations about the suitability
'\" of this software for any purpose.  It is provided "as is" without
'\" express or implied warranty.
'\"
'\" D.I.S. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, IN\-
'\" CLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
'\" NO EVENT SHALL D.I.S.  BE LIABLE FOR  ANY  SPECIAL,  INDIRECT  OR
'\" CONSEQUENTIAL  DAMAGES  OR  ANY DAMAGES WHATSOEVER RESULTING FROM
'\" LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
'\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNEC\-
'\" TION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
'\"
.TH load 3 "7 January 1994" "Shells" "Tcl Functions"
.SH "NAME"
.LP
load \- dynamically load an extension
.SH "SYNOPSIS"
.LP
\fBload\fP \fIlibrary\fP 
.LP
int \fILibName_Init\fP(Tcl_Interp *\fIinterp\fP);
.SH "DESCRIPTION"
.LP
The \fBload\fP command loads an extension into a running TCL interpreter. 
.LP
\fIlibrary\fP is the path name of a shared library containing the
required extension. This library should define a public initialization
function, which is called to install and configure the extension.  The
initialization function is named after the library to be loaded,
capitalizing the first letter and appending the suffix "_Init".
\fILibName_Init\fP() takes as argument a pointer to the TCL
interpreter to be extended and reports success or failure returning
either TCL_OK or TCL_ERROR.
.LP
To auto\-load extension libraries using standard auto\-loading
procedures put in the directory where the shared library resides
a Tcl source file containing something like this (actual path name syntax
is system\-dependent): 
.LP
.nf
#
# Tcl script to autoload libex.so.1.0
#
load [file dirname [info script]]/libex.so.1.0
list {
proc ex_cmd1
proc ex_cmd2
}
.fi
.LP
The first line instructs the interpreter to load the \fIex\fP
shared library found in the same directory as the script, using the
\fIEx_Init\fP() function to initialize it. The \fIlist\fP command
just hides a list of dummy declaration for commands created by
\fIEx_Init\fP(). Since \fIproc\fP is at the beginning of the line,
the standard \fIauto_mkindex\fP procedure will be tricked into thinking
the script contains real functions: when \fIauto_load\fP sources
it procedures will be actually created by the \fIload\fP command.
.LP
It's quite straightforward to have the Makefile for \fIlibex.so.1.0\fP
building a companion \fIlibex.tcl\fP file of this sort and installing
it along the shared library.
.SH "Return Value"
.LP
An empty string
.SH "Exceptions"
.LP
If it is not possible to open or load \fIlibrary\fP or \fILibName_Init\fP
returns a non\-null code, \fBload\fP generates an error and returns an
error message.
.SH "Side effects"
.LP
\fBload\fP creates new TCL commands and variables in the calling interpreter.
.SH "BUGS"
.LP
The auto\-loading scheme is a hack and relies on the naive parsing rules
implemented in \fIauto_mkindex\fP. Maybe future releases of the Tcl
library will make the process more clean and robust.
.LP
The current implementation of \fBload\fP requires system\-specific
support for dynamic linking.
.SH "SEE ALSO"
.LP
\fBdtclsh\fP(1), \fBdwish\fP(1), \fBauto_mkindex\fP and
\fBauto_load\fP in \fBlibrary\fP(n)
