


Tcl-DP(1)                USER COMMANDS                  Tcl-DP(1)



_________________________________________________________________

NAME
     Tcl-DP - distributed programming extension to Tcl/Tk
_________________________________________________________________

DESCRIPTION
     Tcl-DP is a freely distributable  extension  to  Tcl/Tk  and
     stands for Tcl Distributed Programming.  Tcl-DP adds TCP and
     IP connection management, remote procedure call  (RPC),  and
     distributed  object  support to Tcl/Tk.  Tcl stands for Tool
     Command Language, a freely distributable, embeddable script-
     ing language.  Tk stands for Toolkit, a freely distributable
     X windows widget set extension to Tcl.

     This man page provides an overview of the Tcl-DP  programmer
     interface.   The  Tcl/Tk  commands provided by Tcl-DP can be
     separated into three levels:


CONNECTION MANAGEMENT COMMANDS
     Tcl-DP adds to Tcl/Tk several commands  which  manage  basic
     TCP  and  IP  network  connections.   Among these connection
     management commands are address, accept, connect,  shutdown,
     send,  receive, sendTo, receiveFrom, and filehandler.  These
     commands provide basically the same level of service as  the
     UNIX C socket(2) related system calls.

     These connection management  commands  return  and  take  as
     arguments identifiers called _f_i_l_e_I_d's.  (A _f_i_l_e_I_d represents
     a UNIX file  descriptor.   UNIX  uses  file  descriptors  to
     represent  both open files and open sockets.  A socket is an
     endpoint of  network  communication.)   These  _f_i_l_e_I_d's  are
     identical  to the identifiers manipulated by the open, read,
     write, gets, puts, and close  file  management  commands  of
     Tcl.


REMOTE PROCEDURE CALL COMMANDS
     The RPC commands of Tcl-DP are implemented  on  top  of  the
     connection  management  commands  listed  above.  For speed,
     some of the RPC  commands  are  actually  implemented  in  C
     instead  of  Tcl/Tk  scripting.   These RPC commands include
     MakeRPCServer, MakeRPCClient, RPC, and CloseRPC.  The  basic
     RPC command has the following form:

     RPC _f_i_l_e_I_d ?_a_r_g_s?

     Here is an example usage:

     RPC file4 puts stdout "hello world"




Sun Release 4.1           Last change:                          1






Tcl-DP(1)                USER COMMANDS                  Tcl-DP(1)



     The above RPC command  will  send  its  _a_r_g_s  argument  (the
     string  {puts stdout "hello world"}) to the connected remote
     process, represented by  file4.   The  remote  process  will
     evaluate  the  received  _a_r_g_s string in its Tcl interpreter.
     Any return value will be sent back to the waiting RPC caller
     process.  Since all data and commands in Tcl/Tk are strings,
     there are no data conversion or format problems.


DISTRIBUTED OBJECT SUPPORT COMMANDS
     The distributed object commands of Tcl-DP are implemented on
     top  of the RPC commands described above.  An object in Tcl-
     DP is a procedure, just like a widget instance of  Tk  is  a
     procedure.  A procedural object must take as its first argu-
     ment a method selector.  In other words, if  _o_b_j_e_c_t  is  the
     name of a procedural object:

     _o_b_j_e_c_t _m_e_t_h_o_d ?_a_r_g_s ...?

     Objects can have slots.  Objects which are to be distributed
     using  Tcl-DP  must  handle two methods, configure and slot-
     value, which access the slots of the object.

     The configure method must handle three  different  forms  of
     arguments,  which  makes  it  very  much  like the configure
     option for Tk widgets:

     _o_b_j_e_c_t configure ?-_s_l_o_t?
     _o_b_j_e_c_t configure ?-_s_l_o_t _v_a_l_u_e ...?
     _o_b_j_e_c_t configure

     The slot-value method must take one argument:

     _o_b_j_e_c_t slot-value ?_s_l_o_t?

     Objects are usually defined in C for speed but  have  a  Tcl
     access  interface.  For example, Tk widgets are defined in C
     but have Tcl access interfaces.  Objects can also be defined
     using  Tcl/Tk  scripting  only,  as  Tcl-DP supplies several
     utility procedures for  creating  and  manipulating  objects
     with Tcl/Tk scripting only.  (See object(l).)

     Once you have created an object,  you  may  distribute  that
     object  among several RPC connected processes.  Use the Dis-
     tributeObject and UndistributeObject commands.   (The  graph
     of RPC connections among these processes must be acyclic.)

     Once an object is distributed, use the setf  and  getf  com-
     mands,  not  the configure and slot-value methods, to access
     the slots of the distributed object.   These  two  commands,
     setf  and  getf,  replicate  any  slot  value changes to all
     processes where the object is distributed.



Sun Release 4.1           Last change:                          2






Tcl-DP(1)                USER COMMANDS                  Tcl-DP(1)



     You may set triggers on any slot of any  Tcl-DP  distributed
     object with the SetTrigger command.


C INTERFACE
     A C language interface is provided for several of  the  com-
     mands  of Tcl-DP.  See the man pages Address(3), Network(3),
     and RPC(3).


SECURITY
     The Tcl-DP package provides little support  for  access  and
     authentication  security.  With Tcl-DP, any process can send
     any Tcl/Tk command to any remote process.

     A standard measure is  to  remove  or  undefine  "dangerous"
     Tcl/Tk  commands,  through  the Tcl rename command.  Some of
     the Tcl commands which you would  probably  want  to  remove
     include  open, exec, proc, connect (from Tcl-DP), and lastly
     rename.

     The procedure auto_load_all is supplied, which  will  source
     all  autoloading  Tcl  library scripts not already source'd.
     Use auto_load_all before you undefine the Tcl proc command.


AUTHOR
     Brian Smith (bsmith@cs.berkeley.edu)
     Steve Yen (syen@cs.berkeley.edu)


























Sun Release 4.1           Last change:                          3



