/*
 *-----------------------------------------------------------------------------
 *  Copyright (c) 1993-1995 European Synchrotron Radiation Facility
 *
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the "Terms and Conditions of Distribution", given in the documentation
 *  to this software, are applicable and the above copyright message appears
 *  in each copy.
 *
 *-----------------------------------------------------------------------------
 *
 *
 *  CTAXT:      Combine Tcl/Tk with arbitrary X Toolkits 
 *              (into a single application)
 *
 *  Module:	ctaxt.h
 *
 *  Purpose:    Definition of types and functions exported to applications
 *              Includes tcl.h and tk.h
 */




#ifndef _CTAXT
#define _CTAXT




#include <tcl.h>
#include <tk.h>




/*
 *  defines
 */

#define CTAXT_OK               0
#define CTAXT_WARNING          1
#define CTAXT_ERROR            2
#define CTAXT_FATAL_ERROR      3




/*
 *  typedefs
 */

typedef int (CTAXT_TclExtProc) _ANSI_ARGS_((Tcl_Interp *interp,
					    Tk_Window tkwin,
					    ClientData clientData));
typedef int (CTAXT_FreeTclExtProc) _ANSI_ARGS_((Tcl_Interp *interp,
						Tk_Window tkwin,
						ClientData clientData));
typedef int (CTAXT_ExplEventProc) _ANSI_ARGS_((XEvent *event));




/*
 *  Protoypes
 */

int
CTAXT_AddApplicationCommand _ANSI_ARGS_ ((char              *name,
					  Tcl_CmdProc       *cmdProc,
					  ClientData        clientData,
					  Tcl_CmdDeleteProc *delProc,
					  Window            window,
					  Display           *display));

int
CTAXT_AddTclExtension _ANSI_ARGS_ ((CTAXT_TclExtProc *tclExtension,
				    CTAXT_FreeTclExtProc *tclFreeExtension,
				    ClientData clientData));

int
CTAXT_RegisterExplicitEventHandler 
  _ANSI_ARGS_ ((CTAXT_ExplEventProc *handleEventExplicit));

int
CTAXT_PutTclTkInWindow _ANSI_ARGS_ ((Window mainWin,Window win, 
				     Display *disp,char *interpName,
				     char *script,int argc,char *argv[]));

int
CTAXT_MainLoop _ANSI_ARGS_ ((void));

Tk_Window
CTAXT_GetWindow _ANSI_ARGS_ ((Window window,Display *display));

Tcl_Interp *
CTAXT_GetInterpreter _ANSI_ARGS_ ((Window window,Display *display));

char *
CTAXT_GetErrorMessage _ANSI_ARGS_ ((void));

int
CTAXT_CheckVersions _ANSI_ARGS_ ((void));

char *
CTAXT_GetVersion _ANSI_ARGS_ ((void));

#endif /* _CTAXT */
