// ******************************************
// definitionen for class TkPC_object
// ******************************************
// ---------------------------------------------------
// alpha - version of TkPC_object
class TkPC_object
{
   private:
       unsigned long *i_pixels;
       Colormap i_cmap;
       int      i_max_color; /* Groesster belegter Farbindex */
       int      i_off_color; /* Erster belegter Farbindex */
       char     i_name[64];
       char     i_type[64];
       Visual   *i_visual;
       unsigned long i_plane_mask[24]; // is needed for private mask
   public:
       TkPC_object(unsigned long *pixels, Colormap cmap, int max_color, int off_color);
       ~TkPC_object();
       void change_base(unsigned long *p, int max);
       void change_work(unsigned long *p, int max);
       Colormap cmap() { return i_cmap; }
       int maxcolor() { return i_max_color; }
       int offcolor() { return i_off_color; }
       void maxcolor(int x) { i_max_color = x; }
       void offcolor(int x) { i_off_color = x; }
       unsigned long* pixels() { return &i_pixels[0]; }
       unsigned long pixels(int i) { return i_pixels[i]; }
       void pixel(int i, int value) { i_pixels[i] = value; }
       void name(char* name) { strcpy(i_name,name); }
       void type(char* type) { strcpy(i_type,type); }
       char *type() {  return i_type; }
       Visual   *visual() { return i_visual; }
       unsigned long *planemask() { return &i_plane_mask[0]; } 
};

extern TkPC_object::TkPC_object(unsigned long *p, Colormap cm, int max, int off);

extern TkPC_object::~TkPC_object();

extern  void TkPC_object::change_base(unsigned long *p, int max);
extern  void TkPC_object::change_work(unsigned long *p, int max);

// **************************************************************
// END OF OBJECT DEFINITION
// **************************************************************

#ifdef __cplusplus 
extern "C" {
#endif
extern TkPC_object* TkPC_Find(char *name);
extern TkPC_object* Create_TkPC_object(Tcl_Interp* , char*);
extern TkPC_object* Create_TkPC_object_default();
extern TkPC_object* Create_TkPC_object_private();
extern void TkPC_substituteCMAP(Tcl_Interp*, Colormap , Colormap );
extern int connect_widget_with_cmap(Tcl_Interp *interp, TkPC_object *ft, char *tk_path);
extern void free_cmap_entries(TkPC_object *ft, char *off, char *max);
extern int TkPC_CmapName_by_WidgetName(Tcl_Interp *interp, char *widget_name, char *cmapname);
extern Colormap TkPC_Colormap(char *name);
int TkPC_query_Tk_colors(Tcl_Interp *interp);
#ifdef __cplusplus 
}
#endif


extern int TkPC_query_base(Tcl_Interp *interp, char *CmapName);
extern int TkPC_query_work(Tcl_Interp *interp, char *CmapName);
extern int TkPC_alloc_work(Tcl_Interp *interp, char *CmapName, char *VarName);
extern int TkPC_free_work(Tcl_Interp *interp, char *CmapName);
extern int TkPC_store_base(Tcl_Interp *interp, char *CmapName, char *VarName);
extern int TkPC_store_work(Tcl_Interp *interp, char *CmapName, char *VarName);
