
/*
 * Tag types:
 *
 * 	A tag can be either a text, bitmap, connected line, window,
 *	or polygon.
 */

typedef struct Tag Tag;

typedef enum {
    UNKNOWN_TAG_TYPE = (-1),
    TEXT_TAG_TYPE, LINE_TAG_TYPE, POLYGON_TAG_TYPE,
    BITMAP_TAG_TYPE, WINDOW_TAG_TYPE
} TagClassType;

/*
 * This structure corresponds with the specific types of tags.
 * Don't change this structure without changing the individual
 * tag structures of each type in Tag.c.
 */

typedef void (DisplayTagProc) _ANSI_ARGS_((Graph *, Tag *));
typedef void (DestroyTagProc) _ANSI_ARGS_((Graph *, Tag *));
typedef int (ConfigTagProc) _ANSI_ARGS_((Graph *, Tag *));
typedef void (LayoutTagProc) _ANSI_ARGS_((Graph *, Tag *));
typedef void (PrintTagProc) _ANSI_ARGS_((Graph *, Tag *));
typedef char *(TypeOfTagProc) _ANSI_ARGS_((Tag *));

struct Tag {
    TagClassType type;		/* Type of tag */
    unsigned int flags;
    Tk_Uid id;			/* Identifier for tag in list */
    double *coordArr;		/* Coordinate array to position tag */
    int numCoords;		/* Number of points in above array */
    Tk_ConfigSpec *configSpecs;	/* Tag configuration specifications */
    Tk_Uid elemId;		/* Element associated with tag */

    DisplayTagProc *displayProc;
    DestroyTagProc *destroyProc;
    ConfigTagProc *configProc;
    LayoutTagProc *layoutProc;
    PrintTagProc *printProc;
    TypeOfTagProc *typeProc;
};
