'\"
'\" Copyright 1992 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\"
.so man.macros
.HS blt_cutbuffer cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
blt_cutbuffer \- manipulate X cut buffer properties
.SH SYNOPSIS
\fBblt_cutbuffer\fI get ?bufNum?\fR
.br
\fBblt_cutbuffer\fI rotate ?count?\fR
.br
\fBblt_cutbuffer\fI set value ?bufNum?\fR
.BE

.SH DESCRIPTION
.PP
The \fBblt_cutbuffer\fR command allows you to get or set the values of the
eight X cut buffer properties. The \fBblt_cutbuffer\fR command also allows
you to rotate the values of the cut buffer properties. 
Buffer numbers (\fIbufNum\fR) range from 0 to 7 inclusive and default to
0 if not specified.
.SH CUTBUFFER COMMANDS
The following commands are available for the \fBblt_cutbuffer\fR:
.TP
\fBblt_cutbuffer get \fI?bufNum?\fR 
Returns the value of a cutbuffer. 
\fIBufNum\fR must be in the range from 0 to 7 inclusive and defaults to
0 if not specified.  The cutbuffer is returned as-is except, NUL bytes 
are converted to the '@' character.  If the specified cut buffer does not 
exist the empty string is returned.
.TP
\fBblt_cutbuffer rotate \fI?count?\fR 
Rotates the cut buffers by \fIcount\fR. \fICount\fR is an integer number
in the range from -7 to 7 inclusive and defaults to 1 if it is not specified.
.TP
\fBblt_cutbuffer set \fIvalue\fR ?\fIbufNum\fR?
Sets the specified cutbuffer to \fIvalue\fR.  
\fBBufNum\fR must be an integer number in the range 0 to 7 inclusive 
and defaults to zero if not specified.
This command returns the empty string.

.SH KEYWORDS
cut buffer, property
