
set ModeFancyNames {
  {SelectMode 		{Select}}
  {ScaleMode 		{Rescale}}
  {RotateMode		{Rotate}}
  {StretchMode 		{Stretch}}
  {ReshapeMode 		{Reshape}}
  {LineMode             {Line and Polyline Drawing}}
  {RectangleMode        {Rectangle Drawing}}
  {FrectangleMode       {Filled Rectangle Drawing}}
  {OvalMode		{Oval Drawing}}
  {CurveMode		{Curve Drawing}}
  {ArcMode		{Circle Arc Drawing}}
  {PieMode		{Pie Slice Drawing}}
  {CloseCurveMode	{Curved Region Drawing}}
  {CloseLineMode	{Polygon Region Drawing}}
  {TextMode		{Text Insertion}}
  {LatexMode		{Latex Insertion}}}

################################################################
####		     Mouse Bindings                         ####
################################################################

# command string - used to delay bind ops
# until widgets are created

set mouseEvents {}

proc defineMouse {modes states mods type detail op} {
  global MouseBindings ModeFancyNames mouseEvents

  if {($modes == "Any") ||
    ($modes == "any")} {
      set modes [keylget ModeFancyNames]
    }

  set event ""
  if {$mods != {}} {
    set event "[join $mods "-"]-"
  }

  append event "$type"
  if {$detail != ""} {
    append event "-$detail"
  }

  foreach mode $modes {
    foreach state $states {
      keylset MouseBindings $mode.$state.$event $op
    }
  }
  
  lappend mouseEvents $event
}

proc mouseBind {} {
  global mouseEvents

  foreach event $mouseEvents {
    bind [cv] <$event> \
     "ModeHandle $event %x %y %X %Y"
  }
}

proc ModeHandle {event x y X Y} {
  global CurrentMode ModeState MouseBindings

  if {([string first "Motion" $event] < 0) &&
    [winfo containing $X $Y] != [cv]} {
      ##  user clicked outside the canvas during object creation ##
      warn "An item is being created!"
      return
    }
  
  if {[keylget MouseBindings \
       $CurrentMode.$ModeState.$event op]} {
	 eval $op
       }
}

##
##  XF generated class bindings
##

  # Text

  proc TextPick {w} {# xf ignore me 8
  $w yview -pickplace insert}

  proc TextMBoB		{W}	{# xf ignore me 8
  	$W mark set insert 1.0; $W yview -pickplace insert	}
  proc TextMEoB		{W}	{# xf ignore me 8
  	$W mark set insert end; $W yview -pickplace insert	}
  proc TextMPU		{W}	{# xf ignore me 8
	set wh  [expr [winfo height $W]-1]
	set ww  [expr [winfo width $W]-1]
	set fl  [lindex [split [$W index @1,1] .] 0]
	set ti  [expr $fl+1].0

	if [$W compare @$ww,$wh == end] {
	  while {[$W compare @0,$wh > "end - 1 lines"] && $fl > 1} {
	    $W yview [expr $fl-1].0
	    update
	    set fl  [lindex [split [$W index @1,1] .] 0]
	  }
	  $W mark set insert $fl.0
	} {
  	  while {[$W compare @0,$wh > $ti] && $fl > 1} {
	    $W yview [expr $fl-1].0
	    update
	    set fl  [lindex [split [$W index @1,1] .] 0]
	  }
	}

	$W mark set insert $fl.0
	$W yview insert						}
  proc TextMPD		{W}	{# xf ignore me 8
	set wh  [expr [winfo height $W]-1]
	set ww  [expr [winfo width $W]-1]
	set fl  [lindex [split [$W index @1,1] .] 0]
	set ll  [lindex [split [$W index @$ww,$wh] .] 0]
	set tl  [expr $ll-1]

  	  while {$fl < $tl} {
	    $W yview [expr $fl+1].0
	    update
	    set fl  [lindex [split [$W index @1,1] .] 0]
	}

	$W mark set insert $fl.0
	$W yview insert						}
  proc TextMSU		{W n}	{# xf ignore me 8
  	$W yview "@1,1 - $n lines"				}
  proc TextMSD		{W n}	{# xf ignore me 8
  	$W yview "@1,1 + $n lines"				}
	
bind Text <Left>	{# xf ignore me 8
%W mark set insert insert-1c; TextPick %W}
bind Text <Right>	{# xf ignore me 8
%W mark set insert insert+1c; TextPick %W}
bind Text <Up>		{# xf ignore me 8
%W mark set insert insert-1l; TextPick %W}
bind Text <Down>	{# xf ignore me 8
%W mark set insert insert+1l; TextPick %W}
bind Text <Delete>	{tk_textBackspace %W; TextPick %W}

bind Text <Control-a>	{# xf ignore me 8
%W mark set insert "insert linestart"; TextPick %W}
bind Text <Control-b>	{# xf ignore me 8
%W mark set insert insert-1c; TextPick %W}
bind Text <Control-d>	{# xf ignore me 8
%W delete insert insert+1c; TextPick %W}
bind Text <Control-e>	{# xf ignore me 8
%W mark set insert "insert lineend"; TextPick %W}
bind Text <Control-f>	{# xf ignore me 8
%W mark set insert insert+1c; TextPick %W}
bind Text <Meta-h>	{# xf ignore me 8
%W delete "insert linestart" insert; TextPick %W}
bind Text <Control-i>	{# xf ignore me 8
%W inser insert \t; TextPick %W}
bind Text <Control-j>	{# xf ignore me 8
%W inser insert \n; TextPick %W}
bind Text <Control-k>	{if {[%W compare insert == "insert lineend"]} {
    %W delete insert "insert lineend +1c"
    TextPick %W
  } {
    %W delete insert "insert lineend"
    TextPick %W}}
bind Text <Control-l>	{# xf ignore me 8
TextPick %W}
bind Text <Control-m>	{# xf ignore me 8
%W inser insert \n; TextPick %W}
bind Text <Control-n>	{# xf ignore me 8
%W mark set insert insert+1l; TextPick %W}
bind Text <Control-o>	{# xf ignore me 8
%W inser insert \n; TextPick %W}
bind Text <Control-p>	{# xf ignore me 8
%W mark set insert insert-1l; TextPick %W}
bind Text <Meta-v>	{# xf ignore me 8
TextMPU %W}
bind Text <Control-v>	{# xf ignore me 8
TextMPD %W}
bind Text <R9>		{# xf ignore me 8
TextMPU %W}
bind Text <R15>		{# xf ignore me 8
TextMPD %W}
bind Text <Control-w>	{# xf ignore me 8
catch "%W delete sel.first sel.last"}
bind Text <Control-y>	{# xf ignore me 8
%W insert insert "[GetSelection]"; TextPick %W}
bind Text <R7>		{# xf ignore me 8
TextMBoB %W}
bind Text <R13>		{# xf ignore me 8
TextMEoB %W}
bind Text <Prior>	{# xf ignore me 8
set xfCounter [lindex [%W config -height] 4]
  while {$xfCounter > 0} {
    %W mark set insert insert-1l
    incr xfCounter -1
  }
  TextPick %W}
bind Text <Next>	{# xf ignore me 8
set xfCounter [lindex [%W config -height] 4]
  while {$xfCounter > 0} {
    %W mark set insert insert+1l
    incr xfCounter -1
  }
  TextPick %W}

  proc EntryPick {w} {# xf ignore me 8
  tk_entrySeeCaret $w}

bind Entry <Right>	{# xf ignore me 8
%W icursor [expr [%W index insert]+1]; EntryPick %W }
bind Entry <Left>	{# xf ignore me 8
%W icursor [expr [%W index insert]-1]; EntryPick %W }
bind Entry <Control-a>	{# xf ignore me 8
%W icursor 0; %W view 0}
bind Entry <Control-b>	{# xf ignore me 8
%W icursor [expr [%W index insert]-1]; EntryPick %W}
bind Entry <Control-d>	{# xf ignore me 8
%W delete [%W index insert]; EntryPick %W }
bind Entry <Control-e>	{# xf ignore me 8
%W icursor end; EntryPick %W}
bind Entry <Control-f>	{# xf ignore me 8
%W icursor [expr [%W index insert]+1]; EntryPick %W}
bind Entry <Control-h>	{# xf ignore me 8
tk_entryBackspace %W; EntryPick %W}
bind Entry <Meta-h>	{# xf ignore me 8
%W delete 0 insert; %W view insert}
bind Entry <Control-i>	{# xf ignore me 8
%W insert insert \t; EntryPick %W}
bind Entry <Control-k>	{# xf ignore me 8
%W delete insert end; EntryPick %W}
bind Entry <Control-l>	{# xf ignore me 8
EntryPick %W}
bind Entry <Control-v>	{# xf ignore me 8
%W insert insert "[GetSelection]"; EntryPick %W}
bind Entry <Control-w>	{# xf ignore me 8
catch "%W delete sel.first sel.last"; EntryPick %W}
bind Entry <Control-y>	{# xf ignore me 8
%W insert insert "[GetSelection]"; EntryPick %W}



# mouse bindings

  # Text

  bind Text <Button-1> {# xf ignore me 8
    focus %W
    %W mark set insert current
    if ![info exists MBDontSelect(%W)] {
      %W mark set anchor current
    }
  }

  bind Text <Control-Button-1> {# xf ignore me 8
    if ![info exists MBDontSelect(%W)] {
      %W mark set anchor current
    }
  }
  
  bind Text <Any-B1-Motion> {# xf ignore me 8
    if ![info exists MBDontSelect(%W)] {
      set select  [%W index anchor]
      set current [%W index @%x,%y]
      %W tag remove sel 1.0 end
      if {$select < $current} {
        %W tag add sel $select $current
      } {
        %W tag add sel $current $select
      }
    }
  }

  bind Text <B1-Motion> {# xf ignore me 8
    if ![info exists MBDontSelect(%W)] {
      set select  [%W index anchor]
      set current [%W index @%x,%y]
      %W tag remove sel 1.0 end
      if {$select < $current} {
        %W tag add sel $select $current
      } {
        %W tag add sel $current $select
      }
    }
  }

  bind Text <Any-Double-Button-1> {# xf ignore me 8
    if ![info exists MBDontSelect(%W)] {
      %W tag remove sel 1.0 end
      %W tag add sel "current wordstart" "current wordend"
    }
  }
  
  bind Text <Double-Button-1> {# xf ignore me 8
    if ![info exists MBDontSelect(%W)] {
      %W tag remove sel 1.0 end
      %W tag add sel "current wordstart" "current wordend"
    }
  }
  
  bind Text <Button-2> {# xf ignore me 8
    %W mark set insert [%W index @%x,%y]
    if ![catch {selection get}] {
      %W insert insert [selection get]
      %W yview -pickplace insert
    }
  }

  bind Text <Control-Button-2> {# xf ignore me 8
    if ![catch {selection get}] {
      %W insert insert [selection get]
      %W yview -pickplace insert
    }
  }

  bind Text <Button-3> 		{# xf ignore me 8
  	%W scan mark %y}
  bind Text <B3-Motion>		{# xf ignore me 8
  	%W scan dragto %y}
  bind Text <Control-Button-3>	{# xf ignore me 8
  	%W delete insert current}

  # Entry

  bind Entry <Double-Button-1> {# xf ignore me 8
    %W select from 0
    %W select to end
  }

  bind Entry <Button-2> {# xf ignore me 8
    %W icursor [%W index @%x]
    if ![catch {selection get}] {
      %W insert insert [selection get]
      tk_entrySeeCaret %W
    }
  }

  bind Entry <Control-Button-2> {# xf ignore me 8
    if ![catch {selection get}] {
      %W insert insert [selection get]
      tk_entrySeeCaret %W
    }
  }

  bind Entry <Button-3> 	{# xf ignore me 8
  	%W scan mark %x}
  bind Entry <B3-Motion>	{# xf ignore me 8
  	%W scan dragto %x}
  bind Entry <Control-Button-3>	{# xf ignore me 8
  	%W delete insert @%x}
