#
#
# Title: 		hello.tcl 
#
# Tcl version: 	7.3
# Tk version: 	3.6p2 	
#
#
# Compiled Extensions: None.
#
#
# Author: 		Michael K. Ganley
# 				31 August 1995 
#
#  Michael K. Ganley
#  mikegan@world.std.com
#  31 August 1995
#
#


#
# Set new Class Options and toplevel cursor
#
option add *Entry.cursor gumby
. config -cursor {gumby}


#
# showTop
# Procedure to show toplevel window
#
proc showTop {args} {

	global tkVersion
	global tk_strictMotif
	global color
	global language
	global processvar

	wm positionfrom . user
	wm sizefrom . program
	wm geometry . 400x300
	wm maxsize . 400 300
	wm minsize . 100 100

	#
	# Speficic attributes of toplevel window
	#
	set tk_strictMotif 1
	. configure -background $color(toplevel)

	button .b0 \
	 -bg $color(buttons) \
	 -text {Quit} \
	 -command { quitPressed }

	button .b1 \
	 -bg $color(buttons) \
	 -text {Time} \
	 -command { timePressed }

	place .b0 -x 80 -y 250 -width 60 -height 40 -anchor nw
	place .b1 -x 10 -y 250 -width 60 -height 40 -anchor nw

}


#
# quitPressed
# Procedure to set linked variable to proper value	
#
proc quitPressed {} {
	global winup

	set winup 99
}


#
# timePressed
# Status window to display entry for time update
#
proc timePressed {} {
	global color
	global winup

	if { [winfo exists .setupframe] } { return }
	set winup 1

	frame .setupframe \
	 -borderwidth {2} \
	 -background $color(buttons) \
	 -relief {raised}

	button .setupframe.okbutton \
	 -foreground {black} \
	 -background $color(buttons) \
	 -text {OK} \
	 -command "set winup 0;destroy .setupframe"

	frame .setupframe.f0 \
	 -borderwidth {3} \
	 -background $color(buttons) \
	 -relief {groove}

	label .setupframe.f0.datelab \
	 -font {-Adobe-Helvetica-medium-r-Normal--*-120-*} \
	 -text {Date} \
	 -background $color(buttons) \
	 -relief {flat} \
	 -borderwidth {1}

	label .setupframe.f0.timelab \
	 -font {-Adobe-Helvetica-medium-r-Normal--*-120-*} \
	 -text {Time} \
	 -background $color(buttons) \
	 -relief {flat} \
	 -borderwidth {1}

	entry  .setupframe.f0.dateent \
	 -relief {flat} \
	 -background $color(pagelist) \
     -font {-Adobe-Helvetica-medium-R-Normal--*-120-*} \
	 -textvariable setup(date) \
	 -state disabled
	
	entry  .setupframe.f0.timeent \
	 -relief {flat} \
	 -background $color(pagelist) \
     -font {-Adobe-Helvetica-medium-R-Normal--*-120-*} \
	 -textvariable setup(time) \
	 -state disabled

	place .setupframe -x 1 -y 1 -height 300 -width 398 -anchor nw
	place .setupframe.okbutton -x 155 -y 270 -width 80 -height 20 -anchor nw


	place .setupframe.f0 -x 10 -y 10 -width 300 -height 80 -anchor nw
	place .setupframe.f0.datelab -x 5  -y 5 -anchor nw
	place .setupframe.f0.dateent -x 40 -y 5 -width 250 -height 20 -anchor nw
	place .setupframe.f0.timelab -x 5  -y 45 -anchor nw
 	place .setupframe.f0.timeent -x 40 -y 45 -width 250 -height 20 -anchor nw

	newUpdateTime

	while { [ catch {grab set .setupframe} temp0 ] } {puts "$temp0" }
	
}

#
# newUpdateTime
# Time getting command
#
proc newUpdateTime {} {
	global winup
	global setup
	# see C source code for getDateTime formats

	if {$winup == 1} {
		set setup(time) [ getDateTime 1 0 1 ]
		set setup(date) [ getDateTime 0 0 0 ]
		after 500 [list newUpdateTime]
	}

}


#
# enableDeb
# Brings up the utility top level window to illustrate sending to the
# message Queue.  Another task could do this if it sent to the proper
# message queue.
#
proc enableDeb {} {
	global color
	global debugNum
	global qVar
	
	toplevel .deb 

	wm positionfrom .deb user
	wm sizefrom .deb program
	wm geometry .deb 160x120+420+5
	wm maxsize .deb 500 500
	wm minsize .deb 100 120
	wm title .deb {Utility Window} 

	#
	# Speficic attributes of toplevel window
	#
	set tk_strictMotif 1
	.deb configure -background $color(toplevel)

	entry  .deb.e0 \
	 -relief {flat} \
	 -background $color(pagelist) \
     -font {-Adobe-Helvetica-medium-R-Normal--*-120-*} \
	 -textvariable qVar

	button .deb.sendQ \
	 -relief {raised} \
	 -text {Post Message} \
	 -bg $color(buttons) \
	 -command "sendToQproc"

	place .deb.sendQ -x 35 -y 10 -width 90 -height 30 -anchor nw
	place .deb.e0 -x 35 -y 50 -width 90 -height 18 -anchor nw

}

#
# sendToQproc
# Entry procedure
#
proc sendToQproc {} {
	global qVar

	sendToQ $qVar

}

#
# putMsgUp
# Put up dialog box for message if not already
#
proc putMsgUp {} {
	global color

	if { [winfo exists .sMsgPU] } { return }

	frame .sMsgPU \
	 -borderwidth {2} \
	 -relief {raised} \
	 -background $color(dialog) 

	label .sMsgPU.sPic \
	 -relief {flat} \
	 -text {ATTENTION}\
	 -font {-Adobe-Helvetica-Bold-R-Normal--*-240-*} \
	 -background $color(dialog) \
	 -foreground $color(buttons)

	message .sMsgPU.sMsg \
	 -background $color(dialog) \
	 -foreground black \
     -width 390 \
	 -justify center \
	 -font {-Adobe-Helvetica-Bold-R-Normal--*-240-*} \
	 -text { A message was recieved ! } 
	
	button .sMsgPU.sButton \
	 -foreground {black} \
	 -background $color(dialogbuttons) \
	 -text {OK} \
	 -command "destroy .sMsgPU"

	place .sMsgPU -x 2 -y 2 -width 398 -height 300 -anchor nw
	place .sMsgPU.sPic -x 120 -y 10 -anchor nw
	place .sMsgPU.sMsg -x 1 -y 110 -width 390 -anchor nw
	place .sMsgPU.sButton -x 160 -y 235 -width 80 -height 50 -anchor nw

}


#
#  circulate
#  Procedure for continuously making sure that the Event loop doesn't
#  just sit and stall for events to happen.  Necessary to get incoming 
#  messages properly.
#  
proc circulate {} {
	global winup
	global msgFlag

	if { $msgFlag == 1 } {
		set msgFlag 0
		putMsgUp
	}
	after 500 [list circulate]
}


#
#  initGlobals
#  Procedure which holds all variable to be initialized
#
proc initGlobals {} {
	global color
	global winup
	global qVar
	global msgFlag

	set color(mainframe) #65e365e365e3
	set color(buttons) #e041e041e041
	set color(toplevel) #ab01ab01ab01
	set color(pagecolor) #dae0dae0dae0 
	set color(pagelist) #c9bac9bac9ba
	set color(pagescrollback) #b686b686b686
	set color(dialog) #960496049604
	set color(dialogbuttons) #a312a312a312

	set winup 0

	set qVar 0

	set msgFlag 0

}




#
# Start to display by invoking procedures
#
puts "\nStarting the example now..."

initGlobals
showTop
enableDeb


#
# Must initiate circulate procedure to keep alive
#
circulate


# eof
#

