

# create some frames and labels
set f [frame .f -width 200 -height 200]
set f2 [frame .f2 -width 200 -height 200 -bg gray]

set l [label .l -textvariable LabelString -relief groove]
set l2 [label .l2 -textvariable LabelStringAny -relief groove]
set c [checkbutton .c -text "enable printing" -variable PrintingEnabled]

pack .c -fill x
pack $f
pack $f2
pack $c
pack $l -fill x
pack .l2 -fill x

set PrintingEnabled 1

# tie X events to user events
bind $f  <Any-Motion> {userevent raise {Test MouseMoved %W} %W %x %y}
bind $f2 <Any-Motion> {userevent raise {Test MouseMoved %W} %W %x %y}


# bind events:
# 1. look for event in a window:
userevent bind "Test MouseMoved $f" update_label

# 2: look for events in any window:
set update_label_id [userevent bind "Test MouseMoved ?" update_label_any]

# 3: look for all events:
set allid [userevent bind -includeevent {*} printall]


.c config -command "userevent enable $allid \$PrintingEnabled"

proc update_label {w x y} {
    global LabelString

    set LabelString "top win: ($x, $y)"
}

proc update_label_any {w x y} {
    global LabelStringAny

    set LabelStringAny "any win: ($x, $y)"
}


proc printall {args} {
    puts "$args"
}

userevent enable $update_label_id true
puts [userevent getcommand $update_label_id]
