'\"
'\" Copyright (c) 1993 by Sven Delmas
'\" All rights reserved.
'\" See the file COPYRIGHT for the copyright notes.
'\" 
'\" $Header: tkgs.n[7.0] Wed May  4 23:55:03 1994 garfield@mydomain.de frozen $
'/" 
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS tkgs cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
tkgs \- Create and manipulate tkgs widgets
.SH SYNOPSIS
\fBtkgs\fI \fIpathName \fR?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBheight\fR	\fBwidth\fR
\fBborderwidth\fR	\fBrelief\fR
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBbbox\fR
Class:	\fBBbox\fR
Command-Line Switch:	\fB\-bbox\fR
.fi
.IP
This is a list with four numbers specifying the bounding box
to be displayed (this is the postscript bounding box).
.fi
.LP
.nf
Name:	\fBcommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB\-command\fR
.fi
.IP
Specifies the ghostscript executable that is called. The
default command is ''gs -dQUIET -dNOPAUSE
-g${width}x${height} ${file}''. There are several variables
that can be specified in the command. The variables
\fIwidth\fR and \fIheight\fR are replaced by the specified
widget size. The variable \fIfile\fR is replaced by the
filename that should be displayed.
.LP
.nf
Name:	\fBfile\fR
Class:	\fBFile\fR
Command-Line Switch:	\fB\-file\fR
.fi
.IP
Specifies the file that is loaded in the ghostscript when
the widget is created.
.LP
.nf
Name:	\fBorient\fR
Class:	\fBOrientation\fR
Command-Line Switch:	\fB\-orient\fR
.fi
.IP
Specifies the orientation of the displayed postscript file.
This is an integer with one of the following values: 0, 90,
180, or 270.
.LP
.nf
Name:	\fBxDpi\fR
Class:	\fBXDpi\fR
Command-Line Switch:	\fB\-xdpi\fR
.fi
.IP
Specifies the x resolution of the display.
.LP
.nf
Name:	\fByDpi\fR
Class:	\fBYDpi\fR
Command-Line Switch:	\fB\-ydpi\fR
.fi
.IP
Specifies the y resolution of the display.
.BE

.SH DESCRIPTION
.PP
The \fBtkgs\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a tkgs widget.
Additional options, as described above, may be specified on the
command line or in the option database to configure aspects
of the tkgs such as its default background color and relief.
The \fBtkgs\fR command returns the path name of the new
window.
.PP
A tkgs widget displays a postscript document.

.SH "WIDGET COMMAND"
.PP
The \fBtkgs\fR command creates a new Tcl command the name
of which is the same as the path name of the tkgs's window.
This command may be used to invoke various operations on the
widget. It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIPathName\fR is the name of the command. It is the same
as the tkgs widget's path name. \fIOption\fR and the
\fIarg\fRs determine the exact behavior of the command.  The
following commands are possible for tkgs widgets:
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
Queries or modifies the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing
all available options for \fIpathName\fR (see
\fBTk_ConfigureInfo\fR for information on the format of this
list).  If \fIoption\fR is specified with no \fIvalue\fR,
the command returns a list describing the one named
"option" (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is
specified).  If one or more \fIoption\-value\fR pairs are
specified, the command modifies the given widget option(s)
to have the given value(s); in this case, the command returns
an empty string.  \fIOption\fR may have any of the values
accepted by the \fBtkgs\fR command. 
.TP
\fIpathName \fBredisplay\fR
This command redisplays the widget.
.RE

.SH BINDINGS
.PP
The tkgs widget does not allow special bindings. This is
because reparenting is used which means that the events are
passed directly to the child widget.

.SH IMPLEMENTATION
.PP
I tried to keep the changes to Tk as small as possible. The
changes to Tk only add a new command to Tk (xaccess(n)). If
you don't use the new command, you will not notice any
changes compared to the standard wish. Ghostscript is not
modified.
.PP
The basic concept of this widget is that the tkgs widget
provides a pixmap id that ghostscript uses for its
displaying instead of making a new window.

.SH "PERFORMANCE ISSUES"
.PP
Performance is a critical point with the tkgs widget. Each
created widget has a complete ghostscript process. That
means you should be careful with the number of widgets.

.SH BUGS
.PP
.\"
.IP "\(bu"
It is only possible to display the first page in the
postscript document.
.\"
.IP "\(bu"
Surely, there are many bugs.

.SH KEYWORDS
ghostscript, widget, xaccess
