'\"
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for TIX man pages
.de HS
.if '\\$2'tix'        .TH \\$1 n \\$3 \\TIX
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
'
'
.HS tixAddBalloon tix 3.6
.BS
'
'
.SH NAME
tixAddBalloon - Add balloon help to a widget.
'
'
'
.SH SYNOPSIS
\fBtixAddBalloon\fI \fIpathName message ?initWait?\fR?

\fBtixDisableBalloon\fR

\fBtixEnableBalloon\fR
'
'
'----------------------------------------------------------------------
'
.SH DESCRIPTION


\fBtixAddBalloon\fR will add a popup \fBBalloon Help Window\fR to the
widget specified by \fIpathName\fR. When the mouse cursor moves into
the widget, a popup window will appear on top of the window showing
the message specified by the \fImessage\fR argument. The optional
\fIinitWait\fR argument, in millisconds, controls how long the balloon
window should wait before it pops up. The default value is 200
milliseconds.

Balloon windows can be used to tell the user what a widget does. This
is particular useful for icon buttons.

\fBtixDisableBalloon\fR disables all the balloon windows inside an application.

\fBtixEnableBalloon\fR enables all the balloon windows inside an application.

'----------------------------------------------------------------------
.SH CONFIGURATION OPTIONS

The following options can be used to control the appearance of the
balloon windows.

.LP
.nf
.VS
'
'
'----------BEGIN
.LP
.nf
Name:		\fBtixBalloonBg\fR
Class:		\fBTixBalloonBg\fR
.fi
.IP
Specifies the background of all the balloon windows in an application.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBtixBalloonFg\fR
Class:		\fBTixBalloonFg\fR
.fi
.IP
Specifies the foreground of all the balloon windows in an application.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBtixBalloonWidth\fR
Class:		\fBTixBalloonWidth\fR
.fi
.IP
Specifies the width of of all the balloon windows in an application.
(The height of the balloon windows is determined by the length of the
message displayed in the balloon).
'----------END
'
.VE
.BE
'
.SH NOTE

To use these options, you must add them to the options database before
you create any balloon windows. All the balloons in the same
application will use the same option values. Only the options applied
to the root window "." will take effect.

.SH EXAMPLE

.nf
option add *tixBalloonWidth 100

button .b1 -text hello
button .b2 -text hello
button .b3 -text hello

tixAddBalloon .b1 {This button prints the string "hello"}
tixAddBalloon .b2 {This button says the word "hello"}
tixAddBalloon .b3 {This button executes the program "hello"}
.fi

.SH FILES
The file /usr/local/tcl/Tix3.6/demos/balloon.tcl demostrates the use
of balloon windows.
.SH AUTHOR
.PP
Ioi Kim Lam - ioi@graphics.cis.upenn.edu
'
'
'
.SH KEYWORDS
Balloon Help, TIX
