#==============================================================================
#                                 Config.mk
#------------------------------------------------------------------------------
# Configuration file for Tcl SIPP.  Edit the following variables to specify
# the location of required packages and other attribbutes.   
#
# For the macros that point to the Tcl/Tk/TclX include and library files, two
# sets of macros are provided.  The first set point to the installed location
# of the files.  The second set, which are commented out, point to the files
# in adjacent directories (e.g. ../tcl7.4), are used to get the include and
# library files from the distribution build directory.  Removing the '#' on
# these macros will cause them to override the first one.  They default to
# the prefix and exec_prefix specified to the tsipp configure program.
#
# IMPORTANT NOTE:
#     All paths should either be absoulte or relative to the second level
# directories below root of the distribution directory (../../).
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Version number of tsipp (Don't change this).
#
TSIPP_VERSION = 3.2.0

#------------------------------------------------------------------------------
# C compiler & ar commands to use. CC is normally specified on the make
# command line (make CC=gcc).
#
#CC  = cc
AR  = ar

#------------------------------------------------------------------------------
# Compiler debug/optimization/profiling flag to use.  Normally specified on
# the make command line (make CFLAGS=-g).
#
#CFLAGS=

#------------------------------------------------------------------------------
# EXtra flags:
#   o XCFLAGS - Extra compiler flags on all compiles and links
#   o XLDFLAGS - Extra compiler flags to specify at link time.
#   o XLDLIBS - Extra libraries to use at link time.
#
#XCFLAGS =
#XLDFLAGS =
#XLDLIBS =

#------------------------------------------------------------------------------
# If your compiling using installed header files, these are the prefix and
# exec_prefix locations used for Tcl/Tk/TclX.  They default to the location
# your specified for TSIPP, which defaults to /usr/local.

TCL_PREFIX = ${prefix}
TCL_EXEC_PREFIX = ${exec_prefix}

TCL_PREFIX = /usr/local
TCL_EXEC_PREFIX = /usr/local

#------------------------------------------------------------------------------
# Macros pointing to the Tcl include file and library.  Either a combination
# of -L and -ltcl or an absolute path to the library maybe used to specified
# the library location.
#
TCL_INCL    = -I${TCL_PREFIX}/include
TCL_LIB     = -L${TCL_EXEC_PREFIX}/lib -ltcl76
TCL_CONFIG  = ${TCL_EXEC_PREFIX}/lib/tclConfig.sh

#TCL_DIR     = ../../tcl7.6
#TCL_INCL    = -I${TCL_DIR}/generic
#TCL_LIB     = ${TCL_DIR}/unix/libtcl76.a
#TCL_CONFIG  = ${TCL_DIR}/unix/tclConfig.sh

#------------------------------------------------------------------------------
# Macros pointing to the Tk include file and the Tk library.  Either a
# combination of -L and -ltk or an absolute path to the library maybe used to
# specified the library location.  Also, the tkConfig.sh file generated by the
# Tk configure script.  Not needed if --with-tk=NO is used with configure.
#
TK_INCL      = -I${TCL_PREFIX}/include
TK_LIB       = -L${TCL_EXEC_PREFIX}/lib -ltk42
TK_CONFIG    = ${TCL_EXEC_PREFIX}/lib/tkConfig.sh

#TK_DIR       = ../../tk4.2
#TK_INCL      = -I${TK_DIR}/generic
#TK_LIB       = ${TK_DIR}/unix/libtk42.a
#TK_CONFIG    = ${TK_DIR}/unix/tkConfig.sh

#------------------------------------------------------------------------------
# Macros pointing to the TclX include file and library.  Either a combination
# of -L and -ltclx or an absolute path to the library maybe used to specified
# the library location.  Also, the tclxConfig.sh file generated by the TclX
# configure script.
#
TCLX_INCL    = -I${TCL_PREFIX}/include
TCLX_LIB     = -L${TCL_EXEC_PREFIX}/lib -ltclx760
TCLX_CONFIG  = ${TCL_EXEC_PREFIX}/lib/tclxConfig.sh

#TCLX_DIR     = ../../tclX7.6.0
#TCLX_INCL    = -I${TCLX_DIR}/tcl/generic
#TCLX_LIB     = ${TCLX_DIR}/tcl/unix/libtclx760.a
#TCLX_CONFIG  = ${TCLX_DIR}/tcl/unix/tclxConfig.sh

#------------------------------------------------------------------------------
# Macros pointing to the TkX library.  Either a combination of -L and -ltkx or
# an absolute path to the library maybe used to specified the library
# location.  Also, the tkxConfig.sh file generated by the Tk configure script.
# Not needed if --with-tk=NO is used with configure.
#
TKX_LIB      = -L${TCL_EXEC_PREFIX}/lib -ltkx420
TKX_CONFIG   = ${TCL_EXEC_PREFIX}/lib/tkxConfig.sh

#TKX_LIB      = ${TCLX_DIR}/tk/unix/libtkx420.a
#TXK_CONFIG   = ${TCLX_DIR}/tk/unix/tkxConfig.sh

#------------------------------------------------------------------------------
# Define the URT_DEF, URT_INCL and URT_LIB if you are building with the Utah
# Raster Toolkit (URT).  A subset of the URT library is included in this
# distribution.  An installed version of the library can be used if URT_BUILDA
# is set to NO.  Comment these out if you don't want the URT toolkit.
#
# URT_DEF defines a flag that enables RLE code in TSIPP.
# URT_LOCAL will compile the copy of RLE that comes with TSIPP.
# URT_INCL is the directory containing the URT RLE file (rle.h).
# URT_LIB is the linker flags or file path to get URT RLE library (librle.a).
#
URT_BUILD   =  YES
URT_DEF     = -DTSIPP_HAVE_RLE
URT_INCL    = -I../librle
URT_LIB     = 

#------------------------------------------------------------------------------
# Arguments to use in when generating the demo pictures when you do a
# "make demo".  The following arguments may be specified for this flag:
#
#     o -mode rmode - The rendering mode.  The value of rmode is one of PHONG,
#        GOURAUD, FLAT or LINE.  Default is PHONG.
#     o -oversample factor - The oversampling factor.  The default is 2 for
#        most images, a couple are 3.  You might want to set this to 1 to speed
#        up the rendering.
#     o -size isize - The size of the image to render.  The result will be an
#        image isize X isize pixels.  The default is 256 pixels.
#     o -ppm - Force PPM (or PBM for LINE mode) format images to be rendered.
#        The default is to render RLE images if Tcl-SIPP was built with the 
#        Utah Raster Toolkit RLE library and a PPM images if RLE is not
#        available.
#        
DEMOARGS=

#------------------------------------------------------------------------------
# The following definition can be set to non-null for special systems
# like AFS with replication.  It allows the pathnames used for installation
# to be different than those used for actually reference files at
# run-time.  INSTALL_ROOT is prepended to $prefix and $exec_prefix
# when installing files.

INSTALL_ROOT =

#------------------------------------------------------------------------------
# The directories to install the executables, libraries and include files in.

TSIPP_INST_BIN=${exec_prefix}/bin
TSIPP_INST_LIB=${exec_prefix}/lib
TSIPP_INST_INCL=${prefix}/include

#------------------------------------------------------------------------------
# The runtime directory.  This is where the shared runtime and help files are
# installed.

TSIPP_INST_RUNTIME=${prefix}/lib/tsipp${TSIPP_VERSION}
TSIPP_INST_DEMOS=${TSIPP_INST_RUNTIME}/demos

#------------------------------------------------------------------------------
# HTML documentation directory.  Normally installed in the runtime directory.
# If you install it somewhere else, be sure and create a `tsipp' directory
# for the files, so the TSIPP index.html doesn't clobber other file.

TSIPP_INST_HTML=${TSIPP_INST_RUNTIME}/html


