;;; -*-Scheme-*-
;;;
;;; $Id: macros.sch,v 1.2 1993/02/28 21:11:05 cph Exp $
;;;
;;; Copyright (c) 1993 Massachusetts Institute of Technology
;;;
;;; This material was developed by the Scheme project at the
;;; Massachusetts Institute of Technology, Department of Electrical
;;; Engineering and Computer Science.  Permission to copy this
;;; software, to redistribute it, and to use it for any purpose is
;;; granted, subject to the following restrictions and understandings.
;;;
;;; 1. Any copy made of this software must include this copyright
;;; notice in full.
;;;
;;; 2. Users of this software agree to make their best efforts (a) to
;;; return to the MIT Scheme project any improvements or extensions
;;; that they make, so that these may be included in future releases;
;;; and (b) to inform MIT of noteworthy uses of this software.
;;;
;;; 3. All materials developed as a consequence of the use of this
;;; software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4. MIT has made no warrantee or representation that the operation
;;; of this software will be error-free, and MIT is under no
;;; obligation to provide any services, by way of maintenance, update,
;;; or otherwise.
;;;
;;; 5. In conjunction with products arising from the use of this
;;; material, there shall be no use of the name of the Massachusetts
;;; Institute of Technology nor of any adaptation thereof in any
;;; advertising, promotional, or sales literature without prior
;;; written consent from MIT in each case.

;;;; Macros for Scheme Object System

(define-macro define-class
  (lambda (expression expander)
    (expander (if (and (pair? (cdr expression))
		       (pair? (cddr expression))
		       (list? (cdddr expression)))
		  (apply transform:define-class (cdr expression))
		  (error (car expression)
			 "Usage: (~S <name> <superclasses> . <slots>)"
			 (car expression)))
	      expander)))

(define-macro define-generic-procedure
  (lambda (expression expander)
    (expander (if (and (pair? (cdr expression))
		       (pair? (cddr expression))
		       (list? (cdddr expression)))
		  (apply transform:define-generic-procedure (cdr expression))
		  (error (car expression)
			 "Usage: (~S <name> <lambda-list> . <body>)"
			 (car expression)))
	      expander)))

(define-macro define-method
  (lambda (expression expander)
    (expander (if (and (pair? (cdr expression))
		       (pair? (cddr expression))
		       (list? (cdddr expression)))
		  (apply transform:define-method (cdr expression))
		  (error (car expression)
			 "Usage: (~S <name> <lambda-list> . <body>)"
			 (car expression)))
	      expander)))

(define-macro method
  (lambda (expression expander)
    (expander (if (and (pair? (cdr expression))
		       (list? (cddr expression)))
		  (apply transform:method (cdr expression))
		  (error (car expression)
			 "Usage: (~S <lambda-list> . <body>)"
			 (car expression)))
	      expander)))

(define-external (transform:define-class name superclasses . slot-arguments)
  sosmacro)
(define-external (transform:define-generic-procedure name lambda-list . body)
  sosmacro)
(define-external (transform:define-method name lambda-list . body) sosmacro)
(define-external (transform:method lambda-list . body) sosmacro)