package Nephia::Setup::View::TT;
use strict;
use warnings;
use parent qw( Nephia::Setup::Base );

sub index_template_file {
    my $self = shift;
    my $body = $self->templates->{index_template_file};
    $self->approot->file('view', 'index.tt')->spew( $body );
}

1;

__DATA__

app_class_file
---
package $appname;
use strict;
use warnings;
use Nephia;

our $VERSION = 0.01;

path '/' => sub {
    my $req = shift;
    return {
        template => 'index.tt',
        title => '$appname',
    };
};

1;

:::head1 NAME

$appname - Web Application

:::head1 SYNOPSIS

  $ plackup

:::head1 DESCRIPTION

$appname is web application based Nephia.

:::head1 AUTHOR

clever guy

:::head1 SEE ALSO

Nephia

Nephia::View::TT

:::head1 LICENSE

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

:::cut
===

index_template_file
---
<html>
<head>
  <script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.7.2/jquery.min.js"></script>
  <script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.18/jquery-ui.min.js"></script>
  <link rel="stylesheet" href="/static/style.css" />
  <link rel="shortcut icon" href="/static/favicon.ico" />
  <title>[% title %] - a nephia-app</title>
</head>
<body>
  <div class="title">
    <h1>[% title %]</h1>
    <p>with Nephia::View::TT</p>
  </div>
  <address class="generated-by">Generated by Nephia</address>
</body>
</html>
===

common_conf
---
+{
    appname => $appname,
    view => {
        class => 'TT',
    },
};
===
