#!perl
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: t/examples.t
#
#   Copyright © 2015 Van de Bugger
#
#   This file is part of perl-Dist-Zilla-Plugin-Manifest-Write.
#
#   perl-Dist-Zilla-Plugin-Manifest-Write is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by the Free Software
#   Foundation, either version 3 of the License, or (at your option) any later version.
#
#   perl-Dist-Zilla-Plugin-Manifest-Write is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
#   PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along with
#   perl-Dist-Zilla-Plugin-Manifest-Write. If not, see <http://www.gnu.org/licenses/>.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

use strict;
use warnings;
use if $ENV{AUTOMATED_TESTING}, 'Test::DiagINC';
use lib 'ex';
use lib 't';
use version 0.77;

use Path::Tiny;
use Test::More;
use Test::Routine;
use Test::Routine::Util;
use Test::Deep qw{ re };

with 'ManifestWriteTester';

#   `AutoPrereqs` hints:
#   These plugins used indirectly. If they are missed, tests will fail.
use Dist::Zilla::Plugin::GatherDir          ();
use Dist::Zilla::Plugin::MetaYAML           ();
use Dist::Zilla::Plugin::ModuleBuildTiny    ();
use Dist::Zilla::Plugin::PkgVersion         ();
use Dist::Zilla::Plugin::Test::Compile      ();
use Dist::Zilla::Plugin::Test::EOL          ();
use Dist::Zilla::Plugin::Test::NoTabs 0.09  ();
        # ^ `Test::NoTabs` 0.09 generates author test. Previous versions generated release test.

my $ruler = '-' x 80;

#   First line of the freshly generated manifest file may be not the same as the saved manifest,
#   because of plugin version written to the first line comment. This function reads previously
#   saved manifest file, checks it is not empty, makes sure the first line matches the expected
#   regexp, and replaces the first line with regular expression, so version change does not affect
#   the test.
sub manifest($) {
    my ( $manifest ) = @_;
    my $lines = [ path( $manifest )->lines_utf8() ];
        # `lines_utf8( { chomp => 1 } )` works incorrectly,
        # see <https://github.com/dagolden/Path-Tiny/issues/152>.
    chomp( @$lines );
    ok( @$lines > 0, "$manifest is non empty" ) and do {
        ok(
            $lines->[ 0 ] =~ qr{\A\Q# This file was generated with \E(\S+)\s(\S+)\z},
            "first line of $manifest"
         ) and do {
            my ( $plugin, $version ) = ( $1, $2 );
            ok( version::is_lax( $version ), "$manifest: version" );
            $lines->[ 0 ] = re( qr{\A\Q# This file was generated with $plugin \E$version::LAX\z} );
        };
    };
    return $lines;
};

#   Not an actual test. This method just shows content of built `MANIFEST` file.
test 'Show MANIFEST' => sub {
    my ( $self ) = @_;
    if ( $self->exception ) {
        plan skip_all => 'exception occurred';
    };
    #~ my $manifest = path( $self->tzil->built_in )->child( 'MANIFEST' )->slurp_utf8();
    #~ diag( "\n$ruler\n" . $manifest . "$ruler\n" );
    pass;
};

#   Use plugin from the main module synopsis.
run_me 'Synopsis' => {
    plugins => [
        'GatherDir',
        [ '=ManifestWithFileSize', { source_provider => 'GatherDir' } ],
        #  ^^^^^^^^^^^^^^^^^^^^^
    ],
    expected => {
        files => {
            MANIFEST => manifest( 'ex/ManifestWithFileSize.out' ),
        },
    },
};

run_me 'Example of MANIFEST' => {
    extra_files => {
        'COPYING'       => 'license',
        'Changes'       => 'release history log',
        'README'        => 'documentation',
    },
    options => {
        source_provider => 'GatherDir',
    },
    extra_plugins => [
        'PkgVersion',
        'Test::Compile',
        'Test::EOL',
        'Test::NoTabs',
        'ModuleBuildTiny',
    ],
    expected => {
        # No exception expected.
        files => {
            MANIFEST => manifest( 'ex/MANIFEST' ),
        },
    },
};

done_testing;

exit( 0 );

# end of file #
