#!/usr/bin/perl

package eBay::API::XML::Call::GetUserDisputes::GetUserDisputesRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetUserDisputesRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetUserDisputes::GetUserDisputesRequestType

=head1 DESCRIPTION

Requests a list of disputes the requester is involved in as buyer or seller.
The list includes both Unpaid Item and Item Not Received disputes and can
be filtered according to DisputeFilterType. Use a DetailLevel of ReturnAll to
return all data about each dispute, including DisputeResolution and DisputeMessage
elements.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetUserDisputes::GetUserDisputesRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::PaginationType;
use eBay::API::XML::DataType::Enum::DisputeFilterTypeCodeType;
use eBay::API::XML::DataType::Enum::DisputeSortTypeCodeType;


my @gaProperties = ( [ 'DisputeFilterType', 'ns:DisputeFilterTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::DisputeFilterTypeCodeType', '' ]
	, [ 'DisputeSortType', 'ns:DisputeSortTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::DisputeSortTypeCodeType', '' ]
	, [ 'ModTimeFrom', 'xs:dateTime', '', '', '' ]
	, [ 'ModTimeTo', 'xs:dateTime', '', '', '' ]
	, [ 'Pagination', 'ns:PaginationType', ''
	     ,'eBay::API::XML::DataType::PaginationType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDisputeFilterType()

A filter that specifies a subset of disputes to return. The return list
includes both Item Not Received and Unpaid Item disputes.

  RequiredInput: No
#    Argument: 'ns:DisputeFilterTypeCodeType'

=cut

sub setDisputeFilterType {
  my $self = shift;
  $self->{'DisputeFilterType'} = shift
}

=head2 getDisputeFilterType()

#    Returns: 'ns:DisputeFilterTypeCodeType'

=cut

sub getDisputeFilterType {
  my $self = shift;
  return $self->{'DisputeFilterType'};
}


=head2 setDisputeSortType()

The value and sequence to use to sort the returned disputes.

  RequiredInput: No
#    Argument: 'ns:DisputeSortTypeCodeType'

=cut

sub setDisputeSortType {
  my $self = shift;
  $self->{'DisputeSortType'} = shift
}

=head2 getDisputeSortType()

#    Returns: 'ns:DisputeSortTypeCodeType'

=cut

sub getDisputeSortType {
  my $self = shift;
  return $self->{'DisputeSortType'};
}


=head2 setModTimeFrom()

A filter that retrieves disputes whose DisputeModifiedTime is later
than or equal to this value. Specify the time value in GMT.
See the eBay Web Services documentation for information about specifying time values.
For more precise control of the date range filter, it is a good practice to also
specify ModTimeTo. Otherwise, the end of the date range is the present time.
Filtering by date range is optional. You can use date range filters in combination
with other filters like DisputeFilterType to control the amount of data returned.

  RequiredInput: No
#    Argument: 'xs:dateTime'

=cut

sub setModTimeFrom {
  my $self = shift;
  $self->{'ModTimeFrom'} = shift
}

=head2 getModTimeFrom()

#    Returns: 'xs:dateTime'

=cut

sub getModTimeFrom {
  my $self = shift;
  return $self->{'ModTimeFrom'};
}


=head2 setModTimeTo()

A filter that retrieves disputes whose DisputeModifiedTime is earlier
than or equal to this value. Specify the time value in GMT.
See the eBay Web Services documentation for information about specifying time values.
For more precise control of the date range filter, it is a good practice to also
specify ModTimeFrom. Otherwise, all available disputes modified prior to the ModTimeTo value are returned.
Filtering by date range is optional. You can use date range filters in combination
with other filters like DisputeFilterType to control the amount of data returned.

  RequiredInput: No
#    Argument: 'xs:dateTime'

=cut

sub setModTimeTo {
  my $self = shift;
  $self->{'ModTimeTo'} = shift
}

=head2 getModTimeTo()

#    Returns: 'xs:dateTime'

=cut

sub getModTimeTo {
  my $self = shift;
  return $self->{'ModTimeTo'};
}


=head2 setPagination()

The virtual page number of the result set to display. A result set has a number of disputes
divided into virtual pages, with 200 disputes per page. The response can only display one page.
The first page in the result set is number 1. Required. If not specified, a warning is returned
and Pagination.PageNumber is set to 1 by default.

  RequiredInput: Yes
#    Argument: 'ns:PaginationType'

=cut

sub setPagination {
  my $self = shift;
  $self->{'Pagination'} = shift
}

=head2 getPagination()

#    Returns: 'ns:PaginationType'

=cut

sub getPagination {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Pagination'
		,'eBay::API::XML::DataType::PaginationType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
