package Pinto::Remote::Action::Nop;

# ABSTRACT: Run a no-op on a remote repository

use Moose;

use namespace::autoclean;

#------------------------------------------------------------------------------

our $VERSION = '0.034'; # VERSION

#------------------------------------------------------------------------------

extends qw(Pinto::Remote::Action);

#------------------------------------------------------------------------------

override execute => sub {
    my ($self) = @_;
    return $self->post('nop');
};

#------------------------------------------------------------------------------

__PACKAGE__->meta->make_immutable();

#------------------------------------------------------------------------------
1;



=pod

=for :stopwords Jeffrey Ryan Thalhammer Imaginative Software Systems

=head1 NAME

Pinto::Remote::Action::Nop - Run a no-op on a remote repository

=head1 VERSION

version 0.034

=head1 AUTHOR

Jeffrey Ryan Thalhammer <jeff@imaginative-software.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2011 by Imaginative Software Systems.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut


__END__
