package MojoX::Renderer::HTC;

use warnings;
use strict;

use HTML::Template::Compiled;

# ABSTRACT: HTML::Template::Compiled renderer for Mojo

our $VERSION = '0.02';


sub build {
    my ($self, %args) = @_;
    
    return sub {
        my ($mojo, $ctx, $output) = @_;
        
        my $stash = $ctx->stash;
        my $template = HTML::Template::Compiled->new(
            %args,
            filename => $stash->{template},
        );
        
        $template->param(
            %$stash,
        );
        
        $$output = $template->output;
    }
}

1; # End of MojoX::Renderer::HTC

__END__

=pod

=encoding UTF-8

=head1 NAME

MojoX::Renderer::HTC - HTML::Template::Compiled renderer for Mojo

=head1 VERSION

version 0.02

=head1 SYNOPSIS

  use MojoX::Renderer::HTC;

  sub startup {
    my $self = shift;

    $self->types->type(tmpl => 'text/html');

    my $render = MojoX::Renderer::HTC->build(
        %html_template_compiled_params,
    );

    $self->renderer->add_handler( tmpl => $render );
  }

=head1 METHODS

=head2 build

=head1 AUTHOR

Renee Baecker <reneeb@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by Renee Baecker.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
