package ExtUtils::MakeMaker::Patch::DumpAndExit;

our $DATE = '2015-01-14'; # DATE
our $VERSION = '0.02'; # VERSION

use 5.010001;
use strict;
no warnings;

use Data::Dump;
use Module::Patch 0.19 qw();
use base qw(Module::Patch);

our %config;

sub _dump {
    print "# BEGIN DUMP $config{-tag}\n";
    dd @_;
    print "# END DUMP $config{-tag}\n";
}

sub _WriteMakefile {
    _dump({@_});
    $config{-exit_method} eq 'exit' ? exit(0) : die;
}

sub patch_data {
    return {
        v => 3,
        patches => [
            {
                action      => 'replace',
                sub_name    => 'WriteMakefile',
                code        => \&_WriteMakefile,
            },
        ],
        config => {
            -tag => {
                schema  => 'str*',
                default => 'TAG',
            },
            -exit_method => {
                schema  => 'str*',
                default => 'exit',
            },
        },
   };
}

1;
# ABSTRACT: Patch ExtUtils::MakeMaker's WriteMakefile to dump arguments and exit

__END__

=pod

=encoding UTF-8

=head1 NAME

ExtUtils::MakeMaker::Patch::DumpAndExit - Patch ExtUtils::MakeMaker's WriteMakefile to dump arguments and exit

=head1 VERSION

This document describes version 0.02 of ExtUtils::MakeMaker::Patch::DumpAndExit (from Perl distribution ExtUtils-MakeMaker-Dump), released on 2015-01-14.

=head1 DESCRIPTION

This patch can be used to extract %WriteMakefileArgs from `Makefile.PL` script
without actually producing a Makefile.

=for Pod::Coverage ^(patch_data)$

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/ExtUtils-MakeMaker-Dump>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-ExtUtils-MakeMaker-Dump>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=ExtUtils-MakeMaker-Dump>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
