package App::BenchLevenshteinModules;

our $DATE = '2015-09-18'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(@modules);

our @modules = (
    # [module name, routine name]
    ["PERLANCAR::Text::Levenshtein", "editdist"],
    ["Text::Levenshtein", "fastdistance"],
    ["Text::Levenshtein::XS", "distance"],
    ["Text::LevenshteinXS", "distance"],
);

# ABSTRACT: Benchmark various modules calculating the Levenshtein edit distance

__END__

=pod

=encoding UTF-8

=head1 NAME

App::BenchLevenshteinModules - Benchmark various modules calculating the Levenshtein edit distance

=head1 VERSION

This document describes version 0.01 of App::BenchLevenshteinModules (from Perl distribution App-BenchLevenshteinModules), released on 2015-09-18.

=head1 DESCRIPTION

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-BenchLevenshteinModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-BenchLevenshteinModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-BenchLevenshteinModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
