package Cogwheel::Plugin;

use strict;
use Cogwheel;
use Carp;
use Sprocket qw(Plugin);

use overload '""' => sub { shift->as_string(); };

extends qw(Cogwheel::Object Sprocket::Plugin);

has parent_id => (
    isa => 'Str',
    is  => 'rw',
);

has sprocket => (
    isa       => 'Sprocket',
    is        => 'ro',
    default   => sub { $sprocket },
    weak_ref  => 1,
    predicate => 'has_sprocket',
    clearer   => 'remove_sprocket',
);

has _uuid => (
    accessor => 'uuid',
    isa     => 'Str',
    is      => 'ro',
    default => sub { $_[0]->gen_uuid },
);
has name => (
    isa     => 'Str',
    is      => 'ro',
    default => sub { 'Plugin' },
);

has parent_id => (
    isa => 'Any',
    is  => 'rw',
);

sub local_connected  { shift->setup_connection(@_) }
sub remote_connected { shift->setup_connection(@_) }

sub add_plugin {
    my ( $self, $sprocket ) = @_;
    $self->cogwheel_init();
}

sub cogwheel_init { }

sub setup_connection {
    my ( $self, $sprocket, $con, $socket ) = @_;
    $self->log( info => 'taking connection' );
    $self->take_connection($con);
}

sub local_recieve {
    return 1;
}

sub remote_receive {
    return 1;
}

sub log { }

no Moose;
1;
__END__

=head1 NAME

Cogwheel::Plugin - A Cogwheel Plugin baseclass

=head1 VERSION

Version 0.01

=cut

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 METHODS

=over

=item local_connected

Called by Cogwheel::Client when a connection to a server is created.

=item remote_connected

Called by Cogwheel::Server when a connection by a client is created.

=item setup_connection

Called by both local and remote connected

=item local_recieve

Called by Cogwheel::Client when data is recieved.

=item remote_receive

Called by Cogwheel::Server when data is recieved.

=item sprocket

=item has_sprocket

=item remove_sprocket

=item log

=item parent_id

=item add_plugin

Called when this plugin is added to the Cogwheel Client or Server.

=item cogwheel_init

Abstract method to allow custom initalization after add_plugin. Called by add_plugin.

=item name

=item uuid

=item meta


=back

=head1 DEPENDENCIES

=for author to fill in:
    A list of all the other modules that this module relies upon,
    including any restrictions on versions, and an indication whether
    the module is part of the standard Perl distribution, part of the
    module's distribution, or must be installed separately. ]

Obviously L<Moose>, and L<Sprocket>

=head1 INCOMPATIBILITIES

=for author to fill in:
    A list of any modules that this module cannot be used in conjunction
    with. This may be due to name conflicts in the interface, or
    competition for system or program resources, or due to internal
    limitations of Perl (for example, many modules that use source code
    filters are mutually incompatible).

None reported.


=head1 BUGS AND LIMITATIONS

=for author to fill in:
    A list of known problems with the module, together with some
    indication Whether they are likely to be fixed in an upcoming
    release. Also a list of restrictions on the features the module
    does provide: data types that cannot be handled, performance issues
    and the circumstances in which they may arise, practical
    limitations on the size of data sets, special cases that are not
    (yet) handled, etc.

No bugs have been reported.

Please report any bugs or feature requests to
C<bug-acme-dahut-call@rt.cpan.org>, or through the web interface at
L<http://rt.cpan.org>.

=head1 SEE ALSO

L<Moose>, and L<Sprocket>

=head1 AUTHOR

Chris Prather  C<< <perigrin@cpan.org> >>

=head1 COPYRIGHT AND LICENSE

Copyright 2006, 2007 by Infinity Interactive, Inc.

L<http://www.iinteractive.com>

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself. 

=head1 DISCLAIMER OF WARRANTY

BECAUSE THIS SOFTWARE IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE SOFTWARE, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE SOFTWARE "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOFTWARE IS WITH
YOU. SHOULD THE SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL
NECESSARY SERVICING, REPAIR, OR CORRECTION.

IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE SOFTWARE AS PERMITTED BY THE ABOVE LICENCE, BE
LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE
THE SOFTWARE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING
RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A
FAILURE OF THE SOFTWARE TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF
SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGES.
