/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class ExtremityCircleConnect
extends Extremity {
    private final double px;
    private final double py;
    private final Point2D dest;
    private final double radius = 6.0;
    private final double radius2 = 10.0;
    private final double ortho;

    public ExtremityCircleConnect(Point2D point2D, double d) {
        this.px = point2D.getX() - 6.0;
        this.py = point2D.getY() - 6.0;
        this.dest = new Point2D.Double(point2D.getX(), point2D.getY());
        this.ortho = d;
    }

    public void drawU(UGraphic uGraphic) {
        uGraphic = uGraphic.apply(new UStroke(1.5)).apply(new UChangeBackColor(HtmlColorUtils.WHITE));
        uGraphic.apply(new UTranslate(this.dest.getX() - 6.0, this.dest.getY() - 6.0)).draw(new UEllipse(12.0, 12.0));
        double d = -this.ortho * 180.0 / Math.PI + 90.0 - 45.0;
        UEllipse uEllipse = new UEllipse(20.0, 20.0, d, 90.0);
        uGraphic.apply(new UTranslate(this.dest.getX() - 10.0, this.dest.getY() - 10.0)).draw(uEllipse);
    }
}

