# Dies ist eine kleine Beispielsanwendung fr Business::KontoCheck. Das Programm
# list eine Reihe Bankleitzahlen und Kontonummern (durch mindestens ein nicht-alphanumerisches
# Zeichen getrennt) sowie noch evl. nachfolgenden Kommentar ein, testet das Konto auf
# Gltigkeit und gibt die Zeile (ergnzt durch den Rckgabewert) wieder aus. Leerzeilen sowie
# Zeilen ohne Bankleitzahl oder Kontonummer werden unverndert ausgegeben.
#
# Geschrieben 9.6.07, Michael Plugge

use Business::KontoCheck;

open(IN,"testkonten.txt") or die "Kann testkonten.txt nicht ffenen: $!\n";
open(OUT,"> testkonten.out") or die "Kann testkonten.out nicht ffenen: $!\n";

while(<IN>){
   chomp;
   ($valid,$blz,$separator,$kto,$rest)=/(([0-9a-zA-Z\-]+)([^0-9a-zA-Z]+)([0-9]+))?(.*)/;
   if($valid){
      $retval=kto_check($blz,$kto,"");
      print OUT "$blz$separator$kto$rest: $kto_retval{$retval}\n";
   }
   else{
      print OUT "$rest\n";
   }
}

print OUT "\n===============================================\n\nsterreichische Testkonten:\n\n";
open(IN,"testkonten-at.txt") or die "Kann testkonten-at.txt nicht ffenen: $!\n";

while(<IN>){
   chomp;
   ($valid,$blz,$separator,$kto,$rest)=/(([0-9a-zA-Z\-]+)([^0-9a-zA-Z]+)([0-9]+))?(.*)/;
   if($valid){
      $retval=kto_check_at($blz,$kto,"");
      print OUT "$blz$separator$kto$rest: $kto_retval{$retval}\n";
   }
   else{
      print OUT "$rest\n";
   }
}

