# Copyright: 2001-2005 The Perl Foundation.  All Rights Reserved.
# $Id: perldoc.pl 7849 2005-04-16 09:04:20Z bernhard $

=head1 NAME

config/auto/perldoc - Check whether perldoc works

=head1 DESCRIPTION

Determines whether perldoc exists on the system.

=cut

package Configure::Step;

use strict;
use vars qw($description @args);
use Parrot::Configure::Step ':auto', 'capture_output';

$description = "Determining whether perldoc is installed...";

@args = qw(verbose);

sub runstep {
    my $a = capture_output( 'perldoc perldoc' ) || '';
    my $has_perldoc = ($a =~ m/perldoc/) ? 1 : 0;

    Configure::Data->set(has_perldoc => $has_perldoc);

    $Configure::Step::result = $has_perldoc ? 'yes' : 'no';
}

1;
