#-----------------------------------------------------------------------------
# test.pl	OpenOffice::OODoc Installation test	(c) GENICORP
#-----------------------------------------------------------------------------

use OpenOffice::OODoc	1.102;
use Archive::Zip	1.05	qw ( :DEFAULT :CONSTANTS :ERROR_CODES );

print "Starting OpenOffice::OODoc installation test...\n";

#-----------------------------------------------------------------------------
# OOo file generation with Archive::Zip

my $testfile	= $ARGV[0] || "ootest.sxw";
my $imagefile	= 'scarab.png';

print "Creating an OpenOffice.org test file...\n";
my $content	= '';
while (my $line = <DATA>)
	{
	$content .= $line;
	}
my $zipfile	= Archive::Zip->new;
my $member	= $zipfile->addString($content, 'content.xml');
$member->desiredCompressionMethod	( COMPRESSION_DEFLATED );
$member->desiredCompressionLevel	( COMPRESSION_LEVEL_BEST_COMPRESSION );
die "Archive::Zip error\n"
	unless $zipfile->writeToFileNamed($testfile) == AZ_OK;

#-----------------------------------------------------------------------------
# OOo file updating with OpenOffice::OODoc

my $notice	= <<EOM;
This OpenOffice.org document has been generated by the OpenOffice::OODoc
installation procedure. If you can read it, your installation is probably OK.
EOM

print "Opening the test file...\n";
my $doc	= ooDocument(file => $testfile, member => 'content')
	or die "Unable to open the test file\n";

if ( -e $imagefile )
	{
	print "Inserting the logo...\n";
	$doc->createImageStyle('Logo');
	$doc->createImageElement
		(
		"Logo",
		style		=> 'Logo',
		page		=> 1,
		position	=> '2cm, 2cm',
		size		=> '2cm, 2.824cm',
		import		=> $imagefile
		);
	}

print "Appending some text...\n";
$doc->appendParagraph	( text => "File creation date : " . localtime() );
$doc->appendHeader	( text => "Congratulations !", level => "1" );
$doc->appendParagraph	( text => $notice );
$doc->appendParagraph	( text => "Your environment :" );
my $list = $doc->appendItemList;
$doc->appendItem($list, text => $_) for
	(
	"Platform : $^O",
	"Perl version : $]",
	"Archive::Zip version : $Archive::Zip::VERSION",
	"XML::XPath version : $XML::XPath::VERSION",
	"OpenOffice::OODoc version : $OpenOffice::OODoc::VERSION"
	);

print "Saving the file...\n";
$doc->save;

print "Finished - Please check the $testfile file with OpenOffice.org Writer\n";
exit 0;

__DATA__
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE office:document-content PUBLIC "-//OpenOffice.org//DTD OfficeDocument 1.0//EN" "office.dtd">
<office:document-content xmlns:office="http://openoffice.org/2000/office" xmlns:style="http://openoffice.org/2000/style" xmlns:text="http://openoffice.org/2000/text" xmlns:table="http://openoffice.org/2000/table" xmlns:draw="http://openoffice.org/2000/drawing" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:number="http://openoffice.org/2000/datastyle" xmlns:svg="http://www.w3.org/2000/svg" xmlns:chart="http://openoffice.org/2000/chart" xmlns:dr3d="http://openoffice.org/2000/dr3d" xmlns:math="http://www.w3.org/1998/Math/MathML" xmlns:form="http://openoffice.org/2000/form" xmlns:script="http://openoffice.org/2000/script" office:class="text" office:version="1.0">
<office:automatic-styles />
<office:body>
	<text:p text:style-name="Standard">OpenOffice::OODoc installation test</text:p>
</office:body>
</office:document-content>
