# NOTE: Derived from blib/lib/Class/MethodMaker.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package Class::MethodMaker;

#line 1114 "blib/lib/Class/MethodMaker.pm (autosplit into blib/lib/auto/Class/MethodMaker/object_tie_hash.al)"
# ----------------------------------------------------------------------------


# no support for forwarded methods (may not make sense)

sub object_tie_hash {
  my ($class, @args) = @_;
  my %methods;

  while (@args) {
    my $obj_tie_ref = shift @args;
    my $obj_class_ref = $obj_tie_ref->{class}
      or croak "No class passed to object_tie_hash";
    my $tie_hash_ref = $obj_tie_ref->{tie_hash}
      or croak "No tied hash name passed to object_tie_hash";

    my $hash = $obj_tie_ref->{slot}
      or croak "No slot names passef to object_tie_hash";

    my @slot_hash = ( ref($hash) eq 'ARRAY' ) ? @$hash : ($hash);

    #    my $composites = $obj_tie_ref->{'comp_mthds'};
    #    my @composites = ref($composites) eq 'ARRAY' ? @$composites
    #      : defined $composites ? ($composites) : ();

    my $obj_class = shift @$obj_class_ref;

    foreach my $obj_def (@slot_hash) {
      my $new_meth = 'new';
      my $name = $obj_def; # kept for closures

      $methods{$name} = sub {
        my ($self, @list) = @_;
        # when creating : key => [ constructor args ] , key => ...
        # or  key => obj , key => obj ...

        if ( ! defined $self->{$name} ) {
          my ($tie_class, @c_args) = @$tie_hash_ref ;
          # second args of tie is forced into a scalar context.
          tie my (%hash), $tie_class, @c_args;
          $self->{$name} = \%hash;
        }

        if (scalar @list == 1) {
          my $key = shift @list;

          if (ref $key eq 'ARRAY') {
            return @{$self->{$name}}{@$key};
          } else {
            return $self->{$name}->{$key};
          }
        } else {
          while (1) {
            my $key = shift @list;
            defined $key or last;
            my $value = shift @list;
            defined $value or carp "No value for key $key.";

            $self->{$name}->{$key} =
              (ref $value and UNIVERSAL::isa($value, $obj_class))
                ? $value
                  : ref $value eq 'ARRAY'
                    ? $obj_class->$new_meth(@$obj_class_ref,@$value)
                      : $obj_class->$new_meth(@$obj_class_ref) ;
          }
        }
        wantarray ? %{$self->{$name}} : $self->{$name};
      };

      $class->_add_hash_methods(\%methods, $name) ;

    }
  }
  $class->install_methods(%methods);
}

# end of Class::MethodMaker::object_tie_hash
1;
