# NOTE: Derived from blib/lib/Tk/TreeGraph.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package Tk::TreeGraph;

#line 1059 "blib/lib/Tk/TreeGraph.pm (autosplit into blib/lib/auto/Tk/TreeGraph/viewNode.al)"
sub viewNode
  {
    my $dw = shift ;
    my $nodeId = shift;

    my @sc = $dw->cget('-scrollregion');

    # even if the scrollregion is not defined, the array has 4 elements
    # so i must tesst one of the elements of the array
    return 0 unless (defined $sc[0]) ; # 

    my @bb = $dw->bbox("all") ;

    # adjust scroll region is something is outside of it
    foreach my $i (0,1)
      {
        $sc[$i] = $bb[$i] - 50 if ($bb[$i] < $sc[$i]);
      }
    foreach my $i (2,3)
      {
        $sc[$i] = $bb[$i] + 50 if ($bb[$i] > $sc[$i]);
      }

    $dw->configure(-scrollregion => \@sc );

    # get the rectangle coordinates
    my $rectangle_id = $dw -> {node}{rectangle}{$nodeId};
    my ($rx1,$ry1,$rx2,$ry2)= $dw->coords($rectangle_id);

    # get the full canvas coordinates
    my ($cx1,$cy1,$cx2,$cy2) = @sc;
    # compute where is the node within this widget (fraction)
    my ($xf1,$yf1,$xf2,$yf2) = 
      ($rx1/($cx2-$cx1), $ry1/($cy2-$cy1), $rx2/($cx2-$cx1), $ry2/($cy2-$cy1));

    # check if xf is out of view
    my ($xvleft,$xvright) = $dw->xview ;
    my $deltax = $xvright - $xvleft ;

    # put the widget at the center (x wise)
    $dw->xview(moveto=> (($xf1 + $xf2 - $deltax) / 2) )
      if ($xf1< $xvleft or $xf2> $xvright);

    # check if yf is out of view
    my ($yvtop,$yvbottom) = $dw->yview ;
    my $deltay = $yvbottom - $yvtop ;
    $dw->yview(moveto=>(($yf1 + $yf2 - $deltay) / 2 ) )
      if ($yf1 < $yvtop or $yf2 > $yvbottom);

    # print "delay $x $y, fx $xf fy $yf\n" ;
    $dw->idletasks;

    return 1 ;
  }

# end of Tk::TreeGraph::viewNode
1;
