#!perl -w
use strict;
use Test::More;

use Text::Xslate;

my $tx = Text::Xslate->new();

my @data = (
    [ '<: "foo" :>',    "foo"],
    [q{<: 'bar' :>},    "bar"],

    ['<: 0 :>',        0],
    ['<: 42 :>',       42],
    ['<: 0.01 :>',     0.01 ],
    ['<: 1.23 :>',     1.23 ],
    ['<: 1_23 :>',     1_23 ],
    ['<: 1_23.1_2 :>', 1_23.1_2 ],
    ['<: 00777  :>',   00777  ],
    ['<: 0xCAFE :>',   0xCAFE ],
    ['<: 0b1010 :>',   0b1010 ],
    ['<: 00_7_7_7  :>',  00777  ],
    ['<: 0x_C_A_F_E :>', 0xCAFE ],
    ['<: 0b_1_0_1_0 :>', 0b1010 ],

    ['<: "\n\n" :>',     "\n\n" ],
    ['<: "\r\r" :>',     "\r\r" ],
    ['<: "\t\t" :>',     "\t\t" ],
    ['<: "\"\"" :>',     "&quot;&quot;" ],
    ['<: "\+\+" :>',     "\+\+" ],
    ['<: "\\\\\\\\" :>',     "\\\\" ],
    ['<: "<:$foo:>" :>', '&lt;:$foo:&gt;' ],

    [q{<: '\n\n' :>}, '\n\n' ],
    [q{<: '\\\\\\\\' :>}, '\\\\' ],
    [q{<: '\'\'' :>}, '&#39;&#39;' ],
);

foreach my $pair(@data) {
    my($in, $out) = @$pair;
    my %vars;
    is $tx->render_string($in, \%vars), $out or diag $in;
}

done_testing;
