package Task::BeLike::GEEKRUTH;
use Modern::Perl;
our $VERSION = '1.0300'; # VERSION
our $AUTHORITY = 'cpan:GEEKRUTH'; # AUTHORITY
# ABSTRACT: TIMTOWTDI, but this works for GeekRuthie

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Task::BeLike::GEEKRUTH - TIMTOWTDI, but this works for GeekRuthie

=head1 VERSION

version 1.0300

=head1 NAME

Task::BeLike::GEEKRUTH - TIMTOWTDI, but this works for GeekRuthie

=head1 VERSION

version 1.0300

=head1 TASK CONTENTS

=head2 Infrastructure

=head3 L<App::cpanminus>

=head3 L<App::perlbrew>

=head3 L<Code::TidyAll>

=head3 L<Code::TidyAll::Plugin::Test::Vars>

=head3 L<Devel::Local>

=head3 L<Dist::Zilla>

=head3 L<Dist::Zilla::App::Command::cover>

=head3 L<Dist::Zilla::App::Command::critic>

=head3 L<Dist::Zilla::App::Command::dumpphases>

=head3 L<Dist::Zilla::App::Command::lsplugins>

=head3 L<Dist::Zilla::Plugin::TaskWeaver>

=head3 L<Dist::Zilla::Plugin::Git::PushInitial>

=head3 L<Dist::Zilla::PluginBundle::GEEKRUTH>

=head3 L<Dist::Zilla::PluginBundle::GitLab>

=head3 L<OrePAN2>

=head3 L<Perl::Critic>

=head3 L<Perl::Critic::Bangs>

=head3 L<Perl::Critic::Community>

=head3 L<Perl::Critic::StricterSubs>

=head3 L<Perl::Critic::TooMuchCode>

=head3 L<Perl::Tidy>

=head3 L<Pod::Coverage::TrustPod>

=head2 Database Wrangling

=head3 L<DBD::Pg>

=head3 L<DBIx::Class>

=head3 L<DBIx::Class::Schema::Loader>

=head3 L<DBIx::Class::Schema::ResultSetNames>

=head3 L<DBIx::Class::Helpers>

=head3 L<DBIx::Class::TemporalRelations>

=head2 Building Cool Stuff

=head3 L<autodie>

=head3 L<Carp>

=head3 L<Cpanel::JSON::XS>

=head3 L<Dancer2>

=head3 L<Dancer2::Plugin::Ajax>

=head3 L<Dancer2::Plugin::Auth::Extensible>

=head3 L<Dancer2::Plugin::Auth::Extensible::Provider::DBIxClass>

=head3 L<Dancer2::Plugin::Cache::CHI>

=head3 L<Dancer2::Plugin::DBIx::Class>

=head3 L<Dancer2::Plugin::Growler>

=head3 L<Dancer2::Plugin::Minify>

=head3 L<Dancer2::Plugin::REST>

=head3 L<Dancer2::Session::DBIC>

=head3 L<Dancer2::Template::Handlebars>

=head3 L<File::Path>

=head3 L<Modern::Perl>

=head3 L<Moo>

=head3 L<Plack::Handler::Starman>

=head3 L<Template::Plugin::JSON::Escape>

=head3 L<Try::Tiny>

=head3 L<YAML::Tiny>

=head1 INTRODUCTION

I write Perl for a living, and fully expect to do so for the rest of my career, and well into
what passes for "retirement" for a workaholic nerd like me. This
L<Dist::Zilla::Plugin::TaskWeaver> module gathers together the things I use frequently.

=head1 INITIAL INSTALLATION

I use Debian-ish systems, mostly.  Here are the packages I install on a bare system, B<before> 
I L<perlbrew>brew a perl and try to install this Task:

  sudo apt install build-essential direnv     git \
                   libexpat1-dev   libssl-dev postgresql\
                   pq-dev          unzip      vim \
                   zlib1g-dev

=head1 TASK CONTENTS

=pkggoup Testing & Debugging

=pkg Data::Dumper

=pkg File::Temp

=pkg Keyword::DEVELOPMENT

=pkg Memory::Usage

=pkg Smart::Comments

=pkg Test::Dzil

=pkg Test::PostgreSQL

=pkg Test2::V0

=pkg Test2::Tools::Explain;

=pkg Test2::Tools::JSON;

=head1 AUTHOR

D Ruth Holloway <ruth@hiruthie.me>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2022 by D Ruth Holloway.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 AUTHOR

D Ruth Holloway <ruth@hiruthie.me>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2022 by D Ruth Holloway.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
