#/bin/perl
# Copyright (c) 2001 Flavio Soibelmann Glock. All rights reserved.
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
#
# Tests for Set::Infinite::Quantize_Date
# This is work in progress
#

use strict;
use warnings;

use Set::Infinite::Quantize_Date;

Set::Infinite->type('Set::Infinite::Date');

print "1..10\n";

my @horario_mes = Set::Infinite->new("2001-04-01 00:00:00")->quantize('months', 1);
my @horario_dia = $horario_mes[0]->quantize('days', 1) ;
#print "Days $horario_mes[0] = ",@horario_dia,":\n";
print "not " unless join (" ",@horario_dia) eq
	"[2001-04-01 00:00:00..2001-04-02 00:00:00) [2001-04-02 00:00:00..2001-04-03 00:00:00) [2001-04-03 00:00:00..2001-04-04 00:00:00) [2001-04-04 00:00:00..2001-04-05 00:00:00) [2001-04-05 00:00:00..2001-04-06 00:00:00) [2001-04-06 00:00:00..2001-04-07 00:00:00) [2001-04-07 00:00:00..2001-04-08 00:00:00) [2001-04-08 00:00:00..2001-04-09 00:00:00) [2001-04-09 00:00:00..2001-04-10 00:00:00) [2001-04-10 00:00:00..2001-04-11 00:00:00) [2001-04-11 00:00:00..2001-04-12 00:00:00) [2001-04-12 00:00:00..2001-04-13 00:00:00) [2001-04-13 00:00:00..2001-04-14 00:00:00) [2001-04-14 00:00:00..2001-04-15 00:00:00) [2001-04-15 00:00:00..2001-04-16 00:00:00) [2001-04-16 00:00:00..2001-04-17 00:00:00) [2001-04-17 00:00:00..2001-04-18 00:00:00) [2001-04-18 00:00:00..2001-04-19 00:00:00) [2001-04-19 00:00:00..2001-04-20 00:00:00) [2001-04-20 00:00:00..2001-04-21 00:00:00) [2001-04-21 00:00:00..2001-04-22 00:00:00) [2001-04-22 00:00:00..2001-04-23 00:00:00) [2001-04-23 00:00:00..2001-04-24 00:00:00) [2001-04-24 00:00:00..2001-04-25 00:00:00) [2001-04-25 00:00:00..2001-04-26 00:00:00) [2001-04-26 00:00:00..2001-04-27 00:00:00) [2001-04-27 00:00:00..2001-04-28 00:00:00) [2001-04-28 00:00:00..2001-04-29 00:00:00) [2001-04-29 00:00:00..2001-04-30 00:00:00) [2001-04-30 00:00:00..2001-05-01 00:00:00)  ";
print "ok 1\n";



Set::Infinite::Date->date_format("year-month-day");

# $a = Set::Infinite::Quantize_Date->new ('years', 1, '1998-01-01', '2002-01-01');

$a = Set::Infinite->new('1998-01-01', '2002-01-01');
# print "Years:\n", join (" ", $a->quantize('years', 1) ),"\n";
print "not " unless join (" ", $a->quantize('years', 1) ) eq 
	"[1998-01-01..1999-01-01) [1999-01-01..2000-01-01) [2000-01-01..2001-01-01) [2001-01-01..2002-01-01) [2002-01-01..2003-01-01) ";
print "ok 2\n";



$a = Set::Infinite->new('2001-05-02', '2001-05-13');
#print "Weeks:\n ", join (" ", $a->quantize('weeks', 1) ),"\n";
print "not " unless join (" ", $a->quantize('weeks', 1) ) eq 
	"[2001-04-29..2001-05-06) [2001-05-06..2001-05-13) [2001-05-13..2001-05-20) ";
print "ok 3\n";



my (@a);

#print "Years: \n";
tie @a, 'Set::Infinite::Quantize_Date', 'years', 1, '1998-01-01', '2002-01-01';
print "not " unless join (" ",@a) eq
	"[1998-01-01..1999-01-01) [1999-01-01..2000-01-01) [2000-01-01..2001-01-01) [2001-01-01..2002-01-01) [2002-01-01..2003-01-01) ";
print "ok 4\n";



#print "Months: \n";
tie @a, 'Set::Infinite::Quantize_Date', 'months', 1, '1999-11-01', '2000-02-01';
print "not " unless join (" ",@a) eq
	"[1999-11-01..1999-12-01) [1999-12-01..2000-01-01) [2000-01-01..2000-02-01) [2000-02-01..2000-03-01)";
print "ok 5\n";



#print "Days: \n";
tie @a, 'Set::Infinite::Quantize_Date', 'days', 1, '1999-12-28', '2000-01-03';
print "not " unless join (" ",@a) eq
	"[1999-12-28..1999-12-29) [1999-12-29..1999-12-30) [1999-12-30..1999-12-31) [1999-12-31..2000-01-01) [2000-01-01..2000-01-02) [2000-01-02..2000-01-03) [2000-01-03..2000-01-04) ";
print "ok 6\n";



#print "Weeks: \n";
tie @a, 'Set::Infinite::Quantize_Date', 'weeks', 1, '2001-05-02', '2001-05-13';
print "not " unless join (" ",@a) eq
	"[2001-04-29..2001-05-06) [2001-05-06..2001-05-13) [2001-05-13..2001-05-20) ";
print "ok 7\n";



Set::Infinite::Date->date_format("year-month-day hour:min");
#print "Hours: \n";
tie @a, 'Set::Infinite::Quantize_Date', 'hours', 1, '2001-05-02 22:35', '2001-05-03 02:00';
print "not " unless join (" ",@a) eq
	"[2001-05-02 22:00..2001-05-02 23:00) [2001-05-02 23:00..2001-05-03 00:00) [2001-05-03 00:00..2001-05-03 01:00) [2001-05-03 01:00..2001-05-03 02:00) [2001-05-03 02:00..2001-05-03 03:00) ";
print "ok 8\n";



#print "15 minute: \n";
tie @a, 'Set::Infinite::Quantize_Date', 'minutes', 15, '2001-05-02 21:35', '2001-05-02 23:47';
print "not " unless join (" ",@a) eq
	"[2001-05-02 21:30..2001-05-02 21:45) [2001-05-02 21:45..2001-05-02 22:00) [2001-05-02 22:00..2001-05-02 22:15) [2001-05-02 22:15..2001-05-02 22:30) [2001-05-02 22:30..2001-05-02 22:45) [2001-05-02 22:45..2001-05-02 23:00) [2001-05-02 23:00..2001-05-02 23:15) [2001-05-02 23:15..2001-05-02 23:30) [2001-05-02 23:30..2001-05-02 23:45) [2001-05-02 23:45..2001-05-03 00:00) ";
print "ok 9\n";



Set::Infinite::Date->date_format("hour:min:sec");
#print "30 seconds: \n";
tie @a, 'Set::Infinite::Quantize_Date', 'seconds', 30, 
	['21:35:45', '21:43:00'],
	['21:45:10', '21:47:15'];
print "not " unless join (" ",@a) eq
	"[21:35:30..21:36:00) [21:36:00..21:36:30) [21:36:30..21:37:00) [21:37:00..21:37:30) [21:37:30..21:38:00) [21:38:00..21:38:30) [21:38:30..21:39:00) [21:39:00..21:39:30) [21:39:30..21:40:00) [21:40:00..21:40:30) [21:40:30..21:41:00) [21:41:00..21:41:30) [21:41:30..21:42:00) [21:42:00..21:42:30) [21:42:30..21:43:00) [21:43:00..21:43:30)    [21:45:00..21:45:30) [21:45:30..21:46:00) [21:46:00..21:46:30) [21:46:30..21:47:00) [21:47:00..21:47:30) ";
print "ok 10\n";



1;
