#!/usr/bin/perl -w
##

package Bundle::Modules::CPAN::Unstable;

use 5.005;

our $VERSION = 2006.0525; ## (YYYY.MMDD)

##
## Bundle::Modules::CPAN::Unstable
##

package main;

use strict;

use warnings;

use Shell;

use CPANPLUS::Backend;

use Bundle::Modules::Test::Reporter;

my $sh = Shell->new();

my $plus = CPANPLUS::Backend->new( 'conf' => { 'no_update'  => 1,
                                                 'allow_build_interactivity' => 1,
                                                 'cpantest' => 0,
                                                 'verbose' => 0,
                                               } );

my $conf = $plus->configure_object();

$conf->set_conf( 'force' => 0 );

$conf->set_conf( 'prereqs' => 3 ); ## follow

$conf->set_conf( 'signature' => 1 );

$conf->set_conf( 'skiptest' => 0 );

$conf->set_conf( 'timeout' => 1 );

if ( defined( $ENV{'TEST_POD'} ) && ( $ENV{'TEST_POD'} == 1 ) )
{

}
else
{
   $plus->reload_indices( 'update_source' => 1, 'verbose' => 1 );

} ## end if

my $reporter = Bundle::Modules::Test::Reporter->new(
   'grade' => 'unstable',
   'distribution' => 'TBD',
   'from' => '<ermeyers@adelphia.net> (Bundle::Modules::CPAN::Unstable)',
   'comments' => 'Generated by Bundle::Modules::CPAN::Unstable.',
   'via' => 'Bundle::Modules::CPAN::Unstable 2006.0525'

   );

my @module = ();



push( @module, 'Math::TrulyRandom' );

fisher_yates_shuffle( \@module );

for ( my $i = 0; $i <= $#module; $i++ )
{
   my $name = $module[$i];

   $name =~ s/[:][:]/-/g;

   my $mi = $plus->module_tree( $module[$i] );

   printf( "[FILTERING] Next module named %s.\n", $module[$i] );

   eval( '$mi->package_name()' );

   next if ( @$ );

   next if ( $name ne $mi->package_name() );

   my $mid = $mi->package_name() . '-' . $mi->package_version();

   printf( "[BEGINNING] Distribution named %s is to be installed.\n", $mid );

   $mi->install();

   my $mist = $mi->status();

   $reporter->distribution( $mid );

   if ( $mist->installed() )
   {
      if ( ( $mist->signature() && $mist->checksum_ok() && -f $mist->extract().'/SIGNATURE' ) || ! $mist->created() )
      {
         if ( defined( $mist->extract() ) )
         {
            printf( "[REPORTING] %s is installed with a valid signature, sending stable message.\n", $mid );

            $reporter->grade( 'stable' );

         }
         else
         {
            printf( "[REPORTING] %s is already installed, sending installed message.\n", $mid );

            $reporter->grade( 'installed' );

         } ## end if

      }
      else
      {
         printf( "[REPORTING] %s is installed without a trusted signature, sending signature message.\n", $mid );

         $reporter->grade( 'signature' );

      } ## end if

      printf( "[COMPLETED] Distribution named %s is installed.\n", $mid );

   }
   else
   {
      printf( "[REPORTING] %s failed to install, sending unstable message.\n", $mi->name() );

      $reporter->grade( 'unstable' );

      printf( "[COMPLETED] Distribution named %s is not installed.\n", $mid );

   } ## end if

   $reporter->send() || die $reporter->errstr();

   $sh->rm( '-Rf ' . $mist->extract() ) if ( defined( $mist->extract() ) );

} ## end for

##
## fisher_yates_shuffle - cookbook's inplace array permutation
##
sub fisher_yates_shuffle
{
   my $a = shift;

   for ( my $i = @$a; $i--; )
   {
      my $j = int( rand( $i + 1 ) );

      next if ( $i == $j );

      @$a[$i,$j] = @$a[$j,$i];

   } ## end for

} ## end sub fisher_yates_shuffle

1;

__END__

=head1 NAME

Bundle::Modules::CPAN::Unstable - All current I<unstable> modules in CPAN

=head1 SYNOPSIS

perl -MCPAN -e B<'install Bundle::Modules::CPAN::Unstable'>

cpan B<-i Bundle::Modules::CPAN::Unstable>

perl -MBundle::Modules::CPAN::Unstable

=head1 CONTENTS
Shell
Bundle::CPANPLUS
=head1 CHANGES

=over

=item 2006.0510 (YYYY.MMDD)

Initial version of: Bundle::Modules::CPAN::Unstable-2006.0510

This B<L<Bundle::Modules>> component package is in pre-alpha state with hash ordering.

The ordering of listed modules will eventually be prioritized for efficiency and completeness.

Modules commented out of this module list are either I<unstable> or I<stable> in the B<L<Bundle::Modules>> context.

Optimistically, if there are a lot of the modules commented out, then they are I<stable>, and we're listing I<unstable> context.

Optimistically, if there are a few of the modules commented out, then they are I<unstable>, and we're listing I<stable> context.

If you use the command C<B<man Bundle::Modules::CPAN::Unstable>>, type C<B</#>> to see the commented out modules as they're higlighted for you by B<man>.

=item 2006.0520

This contains a newly refined concept of: Bundle::Modules::CPAN::Unstable-2006.0520

This B<L<Bundle::Modules>> component package is in pre-alpha state with randomized hash ordering.

The ordering of listed modules is now shuffled randomly on each run for better efficiency and completeness.

Modules are no longer listed in CONTENTS, like other 'Bundle::' bundles out there.  I just list Bundle::CPANPLUS.

I support the idea of testing of installations in mass, and I use the information provided by CPANPLUS test reports.

The B<L<Bundle::Modules>> suite has I<stable> and I<unstable> listings that will be updated using the information provided by the testers.db

The B<L<Bundle::Modules>> suite uses Module::Build in its Build.PL, and generates a compatible Makefile.PL.

The B<L<Bundle::Modules>> suite uses the CPANPLUS::Backend to create its own random-ordered installations.

=back

=head1 DESCRIPTION

This Bundle package will install all of the modules listed, if they're not commented out of the B<L<Bundle::Modules>> context.

=head1 SEE ALSO

I<L<Bundle::Modules>>, I<L<Bundle::Modules::Unstable>>, I<L<Bundle::Modules::CPAN>>, I<L<Bundle::Modules::Apache>>, I<L<Bundle::Modules::Apache::Unstable>>

=head1 AUTHORS

Eric R. Meyers E<lt>ermeyers@adelphia.netE<gt>

=head1 LICENSE for http://www.cpan.org/authors/id/E/ER/ERMEYERS/Bundle-Modules-2006.0525

perl

This program is free software; you can redistribute it and/or modify it under the same terms as Perl itself.

=head1 COPYRIGHT

Copyright (C) 2006 by Eric R. Meyers E<lt>ermeyers@adelphia.netE<gt>


