use strict;
use warnings;

package App::Embra::Plugin::SnippetsToNotes;
$App::Embra::Plugin::SnippetsToNotes::VERSION = '0.001'; # TRIAL
# ABSTRACT: add fragments of HTML from plugins to file notes

use Method::Signatures;
use Moo;


method transform_files {
    my %snippets;
    for my $snippet ( $self->embra->plugins_with( '-Snippet' ) ) {
        push @{ $snippets{ $snippet->clipboard } }, $snippet->fragment;
    }
    for ( @{ $self->embra->files } ) {
        $_->update_notes( snippets => \%snippets );
    }
}

with 'App::Embra::Role::FileTransformer';

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Embra::Plugin::SnippetsToNotes - add fragments of HTML from plugins to file notes

=head1 VERSION

version 0.001

=head1 DESCRIPTION

This plugin will find all the plugins which have L<snippets|App::Embra::Plugin::Snippets>, and then add their HTML fragments as notes to the files in your site.

This is a L<FileTransformer|App::Embra::Role::FileTransformer> plugin.

=head1 AUTHOR

Daniel Holz <dgholz@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Daniel Holz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
