package Pony;

$VERSION = '1.01';

open 0 or print "Can't Pony '$0'\n" and exit;
(my $code = join "", <0>) =~ s/.*^\s*use\s+Pony\s*;\n//sm;

if($code!~/^[buffy\s]*$/i) { # if it hasn't been encoded
	my $code=ponyize("$code\n__END__");
	open(0, ">$0") or print "Can't Ponyize $0\n" and exit();
	print {0} "use Pony;\n$code" and exit();
} else {
	$code=unpony($code); # $code=~s/\n__END__//;
	eval($code);
	exit();
}

sub ponyize {
	my @chars = split(//, unpack "b*", pop);
	my $i=0;
	foreach (@chars) {
		$_ = $_ ? qw(B U F F Y)[$i] : qw(b u f f y)[$i];
		$i++; $i %= 5;
	}
	
	@chars=scalepony(@chars);

	join('',@chars);
}

sub unpony {
	my @chars=grep { /[buffy]/i; } split(//, pop);
	foreach (@chars) {
		$_=($_=~/[buffy]/)?0:1;
	}
	pack "b*", join '', @chars;
}

sub scalepony {
	my @chars=@_;
        my @unscaledpony=unscaledpony();
	my $scale=sqrt((grep { /@/ } split(//,join('',@unscaledpony)))/@chars);
        $scale=1+int($scale) if $scale != int($scale);

        # pad the pony so that we can scale it without going fubar
        # stroke the pony too, if you feel so inclined.
        foreach my $row (@unscaledpony) {
            $row=$row.(' ' x ($scale*(int(length($row)/$scale)+1)-length($row)));
        }
        push @unscaledpony, (' ' x length($unscaledpony[0]))
          for(0..$scale*(int(@unscaledpony/$scale)+1)-@unscaledpony);

        my @scaledpony=(); my $i=0;
        foreach my $unscaledrow (@unscaledpony) {
                if(++$i % $scale == 0) {
                        my $scaledrow='';
                        my @unscaledrow=split(//, $unscaledrow); my $j=0;
                        foreach my $character (@unscaledrow) {
                                $scaledrow.=$character if(++$j % $scale == 0);
                        }
                        push @scaledpony, $scaledrow;
                }
        }
        @scaledpony=split(//, join("\n", @scaledpony));

	my @BUFFYpony=();
	foreach my $character (@scaledpony) {
		if($character eq '@') { 
			if($#chars!=-1) { # if we have program text remaining
				push @BUFFYpony, shift @chars;
			} else {     # we've run out of program text
				push @BUFFYpony, 'X';
			}
		} else {
			push @BUFFYpony, $character;
		}
	}
	if(@chars) { # we've got program text remaining
		push @BUFFYpony, "\n", "\n", @chars;
	}
	@BUFFYpony;
}

sub unscaledpony {
	# returns a square pony as an array.  All elements are the same
	# length, there is one per line
	my @RLE=(
		[' ',90,'@',1,' ',216],
		[' ',90,'@',2,' ',215],
		[' ',90,'@',3,' ',214],
		[' ',89,'@',3,' ',215],
		[' ',90,'@',4,' ',213],
		[' ',90,'@',4,' ',213],
		[' ',81,'@',1,' ',7,'@',6,' ',212],
		[' ',80,'@',3,' ',7,'@',6,' ',211],
		[' ',80,'@',1,' ',1,'@',2,' ',5,'@',8,' ',210],
		[' ',81,'@',5,' ',1,'@',1,' ',1,'@',9,' ',209],
		[' ',82,'@',17,' ',208],
		[' ',81,'@',19,' ',207],
		[' ',82,'@',19,' ',206],
		[' ',81,'@',19,' ',1,'@',1,' ',205],
		[' ',81,'@',21,' ',205],
		[' ',80,'@',23,' ',204],
		[' ',81,'@',24,' ',202],
		[' ',79,'@',25,' ',1,'@',1,' ',201],
		[' ',78,'@',28,' ',201],
		[' ',78,'@',30,' ',1,'@',1,' ',1,'@',1,' ',195],
		[' ',78,'@',36,' ',193],
		[' ',76,'@',39,' ',192],
		[' ',76,'@',41,' ',190],
		[' ',75,'@',43,' ',189],
		[' ',75,'@',45,' ',187],
		[' ',74,'@',46,' ',187],
		[' ',75,'@',47,' ',185],
		[' ',74,'@',49,' ',184],
		[' ',73,'@',52,' ',182],
		[' ',74,'@',51,' ',182],
		[' ',73,'@',53,' ',181],
		[' ',73,'@',54,' ',180],
		[' ',73,'@',55,' ',179],
		[' ',73,'@',56,' ',178],
		[' ',72,'@',58,' ',177],
		[' ',72,'@',58,' ',177],
		[' ',71,'@',61,' ',175],
		[' ',71,'@',60,' ',176],
		[' ',70,'@',62,' ',175],
		[' ',70,'@',63,' ',174],
		[' ',69,'@',64,' ',174],
		[' ',69,'@',65,' ',173],
		[' ',69,'@',66,' ',172],
		[' ',68,'@',67,' ',172],
		[' ',67,'@',70,' ',170],
		[' ',67,'@',70,' ',170],
		[' ',66,'@',72,' ',169],
		[' ',66,'@',73,' ',168],
		[' ',66,'@',73,' ',168],
		[' ',65,'@',75,' ',167],
		[' ',64,'@',77,' ',166],
		[' ',64,'@',77,' ',166],
		[' ',63,'@',79,' ',165],
		[' ',62,'@',81,' ',164],
		[' ',62,'@',82,' ',163],
		[' ',62,'@',83,' ',162],
		[' ',61,'@',84,' ',162],
		[' ',60,'@',86,' ',161],
		[' ',61,'@',84,' ',162],
		[' ',59,'@',86,' ',162],
		[' ',59,'@',87,' ',161],
		[' ',58,'@',88,' ',161],
		[' ',59,'@',87,' ',161],
		[' ',57,'@',89,' ',161],
		[' ',58,'@',89,' ',160],
		[' ',57,'@',90,' ',160],
		[' ',57,'@',90,' ',160],
		[' ',56,'@',92,' ',159],
		[' ',57,'@',91,' ',159],
		[' ',56,'@',92,' ',159],
		[' ',56,'@',92,' ',159],
		[' ',56,'@',92,' ',159],
		[' ',56,'@',93,' ',158],
		[' ',55,'@',94,' ',158],
		[' ',55,'@',94,' ',158],
		[' ',54,'@',96,' ',157],
		[' ',55,'@',95,' ',157],
		[' ',53,'@',97,' ',157],
		[' ',54,'@',96,' ',157],
		[' ',53,'@',98,' ',156],
		[' ',52,'@',99,' ',156],
		[' ',53,'@',98,' ',156],
		[' ',51,'@',100,' ',156],
		[' ',51,'@',100,' ',156],
		[' ',50,'@',102,' ',155],
		[' ',49,'@',103,' ',155],
		[' ',49,'@',103,' ',155],
		[' ',48,'@',104,' ',155],
		[' ',48,'@',104,' ',155],
		[' ',48,'@',104,' ',155],
		[' ',49,'@',103,' ',155],
		[' ',50,'@',103,' ',154],
		[' ',50,'@',102,' ',155],
		[' ',50,'@',103,' ',154],
		[' ',51,'@',102,' ',154],
		[' ',52,'@',101,' ',154],
		[' ',52,'@',101,' ',154],
		[' ',53,'@',100,' ',154],
		[' ',53,'@',100,' ',154],
		[' ',55,'@',98,' ',154],
		[' ',55,'@',98,' ',154],
		[' ',56,'@',97,' ',154],
		[' ',57,'@',96,' ',154],
		[' ',59,'@',94,' ',154],
		[' ',61,'@',92,' ',154],
		[' ',63,'@',90,' ',154],
		[' ',66,'@',88,' ',153],
		[' ',69,'@',84,' ',154],
		[' ',70,'@',83,' ',154],
		[' ',72,'@',82,' ',153],
		[' ',72,'@',82,' ',153],
		[' ',74,'@',80,' ',153],
		[' ',73,'@',81,' ',153],
		[' ',74,'@',80,' ',153],
		[' ',73,'@',82,' ',152],
		[' ',73,'@',81,' ',153],
		[' ',72,'@',83,' ',152],
		[' ',72,'@',83,' ',152],
		[' ',71,'@',84,' ',152],
		[' ',71,'@',84,' ',152],
		[' ',71,'@',85,' ',151],
		[' ',70,'@',85,' ',95,'@',4,' ',1,'@',1,' ',51],
		[' ',70,'@',86,' ',93,'@',9,' ',49],
		[' ',69,'@',87,' ',93,'@',11,' ',47],
		[' ',69,'@',87,' ',92,'@',14,' ',45],
		[' ',68,'@',89,' ',90,'@',16,' ',44],
		[' ',69,'@',89,' ',89,'@',17,' ',43],
		[' ',67,'@',91,' ',88,'@',19,' ',42],
		[' ',68,'@',92,' ',85,'@',21,' ',41],
		[' ',66,'@',94,' ',86,'@',21,' ',40],
		[' ',67,'@',94,' ',84,'@',23,' ',39],
		[' ',65,'@',97,' ',83,'@',24,' ',38],
		[' ',65,'@',98,' ',80,'@',28,' ',36],
		[' ',64,'@',98,' ',81,'@',28,' ',36],
		[' ',64,'@',100,' ',77,'@',31,' ',35],
		[' ',63,'@',101,' ',78,'@',31,' ',34],
		[' ',63,'@',102,' ',76,'@',33,' ',33],
		[' ',62,'@',104,' ',75,'@',33,' ',33],
		[' ',63,'@',104,' ',73,'@',35,' ',32],
		[' ',62,'@',105,' ',74,'@',34,' ',32],
		[' ',64,'@',104,' ',72,'@',36,' ',31],
		[' ',62,'@',108,' ',70,'@',36,' ',31],
		[' ',63,'@',110,' ',67,'@',36,' ',31],
		[' ',62,'@',110,' ',1,'@',1,' ',66,'@',37,' ',30],
		[' ',61,'@',117,' ',1,'@',2,' ',2,'@',1,' ',1,'@',1,' ',1,'@',1,' ',51,'@',38,' ',30],
		[' ',60,'@',132,' ',1,'@',1,' ',1,'@',1,' ',44,'@',37,' ',30],
		[' ',61,'@',145,' ',1,'@',1,' ',1,'@',1,' ',29,'@',39,' ',29],
		[' ',59,'@',152,' ',2,'@',1,' ',25,'@',39,' ',29],
		[' ',59,'@',159,' ',1,'@',1,' ',18,'@',40,' ',29],
		[' ',59,'@',163,' ',1,'@',1,' ',14,'@',41,' ',28],
		[' ',58,'@',170,' ',1,'@',1,' ',1,'@',1,' ',5,'@',42,' ',28],
		[' ',57,'@',222,' ',28],
		[' ',29,'@',3,' ',25,'@',1,' ',1,'@',220,' ',28],
		[' ',24,'@',1,' ',1,'@',9,' ',23,'@',221,' ',28],
		[' ',24,'@',12,' ',1,'@',1,' ',21,'@',221,' ',27],
		[' ',22,'@',16,' ',20,'@',222,' ',27],
		[' ',20,'@',19,' ',20,'@',221,' ',27],
		[' ',19,'@',21,' ',18,'@',222,' ',27],
		[' ',20,'@',21,' ',18,'@',222,' ',26],
		[' ',18,'@',26,' ',15,'@',222,' ',26],
		[' ',18,'@',30,' ',11,'@',222,' ',26],
		[' ',18,'@',30,' ',12,'@',221,' ',26],
		[' ',17,'@',32,' ',10,'@',223,' ',25],
		[' ',16,'@',35,' ',8,'@',223,' ',25],
		[' ',16,'@',37,' ',5,'@',224,' ',25],
		[' ',15,'@',39,' ',3,'@',226,' ',24],
		[' ',14,'@',269,' ',24],
		[' ',13,'@',270,' ',24],
		[' ',14,'@',270,' ',23],
		[' ',12,'@',272,' ',23],
		[' ',12,'@',272,' ',23],
		[' ',11,'@',274,' ',22],
		[' ',11,'@',274,' ',22],
		[' ',10,'@',22,' ',3,'@',250,' ',22],
		[' ',9,'@',21,' ',6,'@',250,' ',21],
		[' ',8,'@',22,' ',8,'@',248,' ',21],
		[' ',8,'@',20,' ',11,'@',248,' ',20],
		[' ',7,'@',21,' ',12,'@',247,' ',20],
		[' ',7,'@',20,' ',14,'@',247,' ',19],
		[' ',6,'@',21,' ',15,'@',246,' ',19],
		[' ',6,'@',20,' ',17,'@',246,' ',18],
		[' ',5,'@',21,' ',18,'@',245,' ',18],
		[' ',5,'@',20,' ',21,'@',244,' ',17],
		[' ',4,'@',21,' ',22,'@',244,' ',16],
		[' ',3,'@',21,' ',24,'@',243,' ',16],
		[' ',2,'@',22,' ',26,'@',241,' ',16],
		[' ',3,'@',20,' ',28,'@',241,' ',15],
		[' ',1,'@',22,' ',29,'@',240,' ',15],
		[' ',2,'@',20,' ',31,'@',239,' ',15],
		[' ',1,'@',21,' ',33,'@',238,' ',14],
		[' ',2,'@',19,' ',34,'@',238,' ',14],
		[' ',3,'@',19,' ',35,'@',236,' ',14],
		[' ',4,'@',19,' ',35,'@',236,' ',13],
		[' ',6,'@',17,' ',36,'@',234,' ',14],
		[' ',6,'@',20,' ',34,'@',234,' ',13],
		[' ',7,'@',19,' ',1,'@',1,' ',33,'@',233,' ',13],
		[' ',8,'@',21,' ',33,'@',232,' ',13],
		[' ',9,'@',21,' ',34,'@',230,' ',13],
		[' ',10,'@',22,' ',32,'@',231,' ',12],
		[' ',11,'@',21,' ',33,'@',230,' ',12],
		[' ',12,'@',22,' ',32,'@',230,' ',11],
		[' ',12,'@',22,' ',34,'@',228,' ',11],
		[' ',13,'@',22,' ',33,'@',229,' ',10],
		[' ',14,'@',21,' ',35,'@',227,' ',10],
		[' ',15,'@',20,' ',36,'@',226,' ',10],
		[' ',16,'@',20,' ',38,'@',225,' ',8],
		[' ',16,'@',20,' ',40,'@',223,' ',8],
		[' ',17,'@',19,' ',42,'@',221,' ',8],
		[' ',18,'@',18,' ',44,'@',219,' ',8],
		[' ',19,'@',18,' ',46,'@',216,' ',8],
		[' ',20,'@',17,' ',47,'@',215,' ',8],
		[' ',21,'@',17,' ',49,'@',213,' ',7],
		[' ',21,'@',17,' ',50,'@',212,' ',7],
		[' ',22,'@',15,' ',53,'@',211,' ',6],
		[' ',22,'@',16,' ',53,'@',209,' ',7],
		[' ',23,'@',14,' ',56,'@',207,' ',7],
		[' ',24,'@',14,' ',56,'@',206,' ',7],
		[' ',25,'@',12,' ',58,'@',205,' ',7],
		[' ',27,'@',9,' ',61,'@',203,' ',7],
		[' ',27,'@',9,' ',62,'@',203,' ',6],
		[' ',29,'@',6,' ',64,'@',202,' ',6],
		[' ',30,'@',5,' ',66,'@',200,' ',6],
		[' ',101,'@',40,' ',2,'@',158,' ',6],
		[' ',102,'@',33,' ',13,'@',153,' ',6],
		[' ',103,'@',30,' ',20,'@',149,' ',5],
		[' ',103,'@',29,' ',25,'@',144,' ',6],
		[' ',103,'@',28,' ',30,'@',141,' ',5],
		[' ',104,'@',26,' ',33,'@',139,' ',5],
		[' ',103,'@',26,' ',37,'@',137,' ',4],
		[' ',104,'@',25,' ',41,'@',12,' ',1,'@',1,' ',4,'@',115,' ',4],
		[' ',103,'@',25,' ',64,'@',111,' ',4],
		[' ',104,'@',24,' ',65,'@',111,' ',3],
		[' ',103,'@',24,' ',67,'@',110,' ',3],
		[' ',104,'@',24,' ',67,'@',63,' ',1,'@',46,' ',2],
		[' ',103,'@',24,' ',69,'@',61,' ',3,'@',45,' ',2],
		[' ',104,'@',24,' ',70,'@',59,' ',3,'@',45,' ',2],
		[' ',103,'@',25,' ',70,'@',58,' ',5,'@',44,' ',2],
		[' ',104,'@',23,' ',73,'@',57,' ',4,'@',45,' ',1],
		[' ',104,'@',24,' ',73,'@',55,' ',5,'@',44,' ',2],
		[' ',104,'@',24,' ',74,'@',54,' ',6,'@',44,' ',1],
		[' ',104,'@',23,' ',76,'@',53,' ',5,'@',44,' ',2],
		[' ',104,'@',24,' ',76,'@',52,' ',6,'@',43,' ',2],
		[' ',104,'@',23,' ',78,'@',51,' ',5,'@',44,' ',2],
		[' ',104,'@',24,' ',79,'@',49,' ',6,'@',43,' ',2],
		[' ',104,'@',23,' ',80,'@',49,' ',6,'@',42,' ',3],
		[' ',104,'@',23,' ',82,'@',46,' ',8,'@',42,' ',2],
		[' ',104,'@',22,' ',83,'@',46,' ',7,'@',42,' ',3],
		[' ',104,'@',23,' ',83,'@',45,' ',8,'@',41,' ',3],
		[' ',104,'@',22,' ',85,'@',44,' ',7,'@',42,' ',3],
		[' ',104,'@',23,' ',85,'@',43,' ',8,'@',40,' ',4],
		[' ',104,'@',22,' ',87,'@',41,' ',9,'@',40,' ',4],
		[' ',104,'@',22,' ',88,'@',41,' ',9,'@',39,' ',4],
		[' ',104,'@',22,' ',90,'@',38,' ',10,'@',39,' ',4],
		[' ',104,'@',22,' ',91,'@',38,' ',9,'@',39,' ',4],
		[' ',105,'@',21,' ',91,'@',37,' ',11,'@',38,' ',4],
		[' ',104,'@',22,' ',93,'@',36,' ',10,'@',38,' ',4],
		[' ',105,'@',21,' ',93,'@',35,' ',10,'@',39,' ',4],
		[' ',104,'@',22,' ',94,'@',35,' ',10,'@',39,' ',3],
		[' ',105,'@',20,' ',96,'@',35,' ',9,'@',38,' ',4],
		[' ',104,'@',22,' ',96,'@',34,' ',10,'@',38,' ',3],
		[' ',105,'@',20,' ',98,'@',33,' ',10,'@',37,' ',4],
		[' ',104,'@',21,' ',99,'@',33,' ',9,'@',37,' ',4],
		[' ',105,'@',20,' ',99,'@',32,' ',10,'@',37,' ',4],
		[' ',105,'@',19,' ',101,'@',32,' ',10,'@',36,' ',4],
		[' ',104,'@',20,' ',101,'@',32,' ',10,'@',36,' ',4],
		[' ',105,'@',20,' ',100,'@',33,' ',9,'@',37,' ',3],
		[' ',104,'@',20,' ',100,'@',34,' ',10,'@',35,' ',4],
		[' ',104,'@',20,' ',99,'@',35,' ',10,'@',35,' ',4],
		[' ',105,'@',18,' ',100,'@',35,' ',10,'@',35,' ',4],
		[' ',104,'@',20,' ',97,'@',38,' ',10,'@',33,' ',5],
		[' ',105,'@',19,' ',97,'@',38,' ',10,'@',33,' ',5],
		[' ',105,'@',19,' ',95,'@',40,' ',10,'@',34,' ',4],
		[' ',104,'@',19,' ',96,'@',40,' ',10,'@',34,' ',4],
		[' ',105,'@',18,' ',94,'@',42,' ',11,'@',33,' ',4],
		[' ',105,'@',18,' ',93,'@',43,' ',10,'@',33,' ',5],
		[' ',105,'@',18,' ',92,'@',15,' ',5,'@',24,' ',11,'@',33,' ',4],
		[' ',105,'@',18,' ',90,'@',16,' ',7,'@',23,' ',11,'@',33,' ',4],
		[' ',105,'@',18,' ',90,'@',14,' ',11,'@',21,' ',11,'@',33,' ',4],
		[' ',105,'@',17,' ',90,'@',13,' ',14,'@',20,' ',12,'@',32,' ',4],
		[' ',105,'@',17,' ',89,'@',13,' ',16,'@',19,' ',12,'@',32,' ',4],
		[' ',105,'@',17,' ',88,'@',12,' ',19,'@',18,' ',12,'@',32,' ',4],
		[' ',106,'@',16,' ',88,'@',10,' ',22,'@',17,' ',13,'@',30,' ',5],
		[' ',105,'@',17,' ',89,'@',9,' ',22,'@',17,' ',13,'@',30,' ',5],
		[' ',106,'@',16,' ',87,'@',10,' ',23,'@',17,' ',13,'@',30,' ',5],
		[' ',105,'@',16,' ',88,'@',12,' ',21,'@',16,' ',15,'@',29,' ',5],
		[' ',105,'@',16,' ',88,'@',10,' ',1,'@',1,' ',22,'@',15,' ',15,'@',28,' ',6],
		[' ',106,'@',15,' ',87,'@',13,' ',21,'@',16,' ',15,'@',28,' ',6],
		[' ',105,'@',16,' ',87,'@',14,' ',21,'@',15,' ',16,'@',27,' ',6],
		[' ',106,'@',14,' ',88,'@',15,' ',19,'@',16,' ',16,'@',26,' ',7],
		[' ',106,'@',14,' ',87,'@',17,' ',19,'@',15,' ',16,'@',26,' ',7],
		[' ',105,'@',15,' ',86,'#',1,' ',1,'@',13,' ',1,'@',2,' ',19,'@',14,' ',17,'@',25,' ',8],
		[' ',106,'@',14,' ',87,'@',17,' ',19,'@',14,' ',18,'@',24,' ',8],
		[' ',106,'@',14,' ',86,'@',19,' ',18,'@',14,' ',18,'@',24,' ',8],
		[' ',106,'@',14,' ',87,'@',16,' ',21,'@',13,' ',18,'@',23,' ',9],
		[' ',106,'@',13,' ',88,'@',18,' ',18,'@',14,' ',19,'@',22,' ',9],
		[' ',106,'@',14,' ',88,'@',16,' ',19,'@',14,' ',20,'@',21,' ',9],
		[' ',106,'@',13,' ',89,'@',16,' ',20,'@',13,' ',20,'@',21,' ',9],
		[' ',106,'@',13,' ',89,'@',16,' ',20,'@',13,' ',20,'@',20,' ',10],
		[' ',106,'@',13,' ',90,'@',15,' ',19,'@',13,' ',21,'@',19,' ',11],
		[' ',106,'@',13,' ',90,'@',14,' ',21,'@',13,' ',21,'@',19,' ',10],
		[' ',106,'@',12,' ',91,'@',14,' ',21,'@',13,' ',21,'@',18,' ',11],
		[' ',106,'@',13,' ',91,'@',11,' ',23,'@',13,' ',22,'@',17,' ',11],
		[' ',107,'@',11,' ',92,'@',11,' ',23,'@',12,' ',23,'@',16,' ',12],
		[' ',106,'@',13,' ',92,'@',8,' ',25,'@',13,' ',23,'@',15,' ',12],
		[' ',106,'@',12,' ',92,'@',7,' ',27,'@',12,' ',24,'@',15,' ',12],
		[' ',106,'@',12,' ',93,'@',5,' ',28,'@',13,' ',23,'@',15,' ',12],
		[' ',106,'@',12,' ',94,'@',2,' ',31,'@',12,' ',24,'@',13,' ',13],
		[' ',106,'@',12,' ',127,'@',12,' ',24,'@',13,' ',13],
		[' ',107,'@',11,' ',127,'@',12,' ',24,'@',13,' ',13],
		[' ',106,'@',12,' ',127,'@',12,' ',25,'@',11,' ',14],
		[' ',105,'@',12,' ',129,'@',10,' ',26,'@',11,' ',14],
		[' ',105,'@',13,' ',127,'@',12,' ',26,'@',10,' ',14],
		[' ',105,'@',12,' ',129,'@',11,' ',26,'@',9,' ',15],
		[' ',104,'@',13,' ',129,'@',11,' ',27,'@',7,' ',16],
		[' ',103,'@',14,' ',129,'@',11,' ',29,'@',5,' ',16],
		[' ',102,'@',15,' ',129,'@',11,' ',50],
		[' ',101,'@',16,' ',129,'@',11,' ',50],
		[' ',100,'@',16,' ',130,'@',11,' ',50],
		[' ',98,'@',18,' ',130,'@',11,' ',50],
		[' ',98,'@',17,' ',131,'@',11,' ',50],
		[' ',96,'@',18,' ',131,'@',12,' ',50],
		[' ',96,'@',17,' ',132,'@',13,' ',49],
		[' ',94,'@',18,' ',133,'@',12,' ',50],
		[' ',93,'@',18,' ',132,'@',14,' ',50],
		[' ',92,'@',17,' ',134,'@',14,' ',50],
		[' ',91,'@',18,' ',132,'@',16,' ',50],
		[' ',90,'@',18,' ',132,'@',16,' ',51],
		[' ',89,'@',18,' ',132,'@',16,' ',52],
		[' ',89,'@',17,' ',132,'@',1,' ',1,'@',13,' ',54],
		[' ',87,'@',19,' ',132,'@',14,' ',55],
		[' ',88,'@',17,' ',132,'@',13,' ',57],
		[' ',87,'@',18,' ',131,'@',13,' ',58],
		[' ',86,'@',18,' ',132,'@',12,' ',59],
		[' ',87,'@',17,' ',130,'@',13,' ',60],
		[' ',92,'@',11,' ',131,'@',13,' ',60],
		[' ',98,'@',3,' ',132,'@',14,' ',60],
		[' ',233,'@',13,' ',61],
		[' ',233,'@',1,' ',1,'@',9,' ',63],
		[' ',236,'@',1,' ',1,'@',3,' ',1,'@',1,' ',64]
	);
	my @uncompressed=();
	foreach my $line (@RLE) {
		my @thisline=@{$line};
		my $uncompressedline='';
		while(@thisline) {
			my($char, $count)=(shift @thisline,shift @thisline);
			$uncompressedline.=$char x $count;
		}
		push @uncompressed, $uncompressedline;
	}
	return @uncompressed;
}

1;

__END__

=head1 NAME

Pony - An encoding scheme for Silly People

=head1 SYNOPSIS

  use Pony;

  print "Hello world";

=head1 DESCRIPTION

The first time you run a program under C<use Pony>, the module
removes all that nasty text stuff from your source file, turning
it into a lovely ASCII-art rendition of a pony.  In the spirit of
other london.pm modules, the ASCII-art will consist entirely of
the characters matching /[buffy]+/i, thus fulfilling Greg, Leon
and Dave's fantasy of seeing Buffy riding a Pony.

=head1 DIAGNOSTICS

=over 4

=item C<Can't pony '%s'>

Pony couldn't access the source file for modification.

=item C<Can't unpony '%s'>

Pony couldn't access the source file for execution.

=head1 BUGS

Your file should not consist of more than about 5000 characters,
cos the image will only scale down, not up.

=head1 AUTHOR

David Cantrell <david@cantrell.org.uk>

This is based on Leon Brocard's 'Buffy' module and inspired by Damian
Conway's brief talk on his Bleach module.

=head1 COPYRIGHT

Copyright (c) 2001, David Cantrell.  The Artistic Licence applies.
