package Bio::FastParsers::Blast::Xml::Parameters;
# ABSTRACT: NCBI BLAST DTD-derived internal class
$Bio::FastParsers::Blast::Xml::Parameters::VERSION = '0.180470';
use Moose;
use namespace::autoclean;

# AUTOGENERATED CODE! DO NOT MODIFY THIS FILE!

use XML::Bare qw(forcearray);



# private attributes

has '_root' => (
    is       => 'ro',
    isa      => 'HashRef',
    required => 1,
);


# public array(s) of composed objects


# public composed object(s)


# public methods


sub entrez_query {
    return shift->_root->{'Parameters_entrez-query'}->{'value'}
}


sub expect {
    return shift->_root->{'Parameters_expect'}->{'value'}
}


sub filter {
    return shift->_root->{'Parameters_filter'}->{'value'}
}


sub gap_extend {
    return shift->_root->{'Parameters_gap-extend'}->{'value'}
}


sub gap_open {
    return shift->_root->{'Parameters_gap-open'}->{'value'}
}


sub include {
    return shift->_root->{'Parameters_include'}->{'value'}
}


sub matrix {
    return shift->_root->{'Parameters_matrix'}->{'value'}
}


sub pattern {
    return shift->_root->{'Parameters_pattern'}->{'value'}
}


sub sc_match {
    return shift->_root->{'Parameters_sc-match'}->{'value'}
}


sub sc_mismatch {
    return shift->_root->{'Parameters_sc-mismatch'}->{'value'}
}


# public aliases


sub evalue {
    return shift->expect
}


__PACKAGE__->meta->make_immutable;
1;

__END__

=pod

=head1 NAME

Bio::FastParsers::Blast::Xml::Parameters - NCBI BLAST DTD-derived internal class

=head1 VERSION

version 0.180470

=head1 SYNOPSIS

    # see Bio::FastParsers::Blast::Xml

=head1 DESCRIPTION

This class implements the C<Parameters> level of the XML BLAST parser.

=head1 METHODS

=head2 entrez_query

Returns the value of the element C<<Parameters_entrez-query>>.

    # $parameters is a Bio::FastParsers::Blast::Xml::Parameters
    my $entrez_query = $parameters->entrez_query;

This method does not accept any arguments.

=head2 expect

Returns the value of the element C<<Parameters_expect>>.

    # $parameters is a Bio::FastParsers::Blast::Xml::Parameters
    my $expect = $parameters->expect;

This method does not accept any arguments.

=head2 filter

Returns the value of the element C<<Parameters_filter>>.

    # $parameters is a Bio::FastParsers::Blast::Xml::Parameters
    my $filter = $parameters->filter;

This method does not accept any arguments.

=head2 gap_extend

Returns the value of the element C<<Parameters_gap-extend>>.

    # $parameters is a Bio::FastParsers::Blast::Xml::Parameters
    my $gap_extend = $parameters->gap_extend;

This method does not accept any arguments.

=head2 gap_open

Returns the value of the element C<<Parameters_gap-open>>.

    # $parameters is a Bio::FastParsers::Blast::Xml::Parameters
    my $gap_open = $parameters->gap_open;

This method does not accept any arguments.

=head2 include

Returns the value of the element C<<Parameters_include>>.

    # $parameters is a Bio::FastParsers::Blast::Xml::Parameters
    my $include = $parameters->include;

This method does not accept any arguments.

=head2 matrix

Returns the value of the element C<<Parameters_matrix>>.

    # $parameters is a Bio::FastParsers::Blast::Xml::Parameters
    my $matrix = $parameters->matrix;

This method does not accept any arguments.

=head2 pattern

Returns the value of the element C<<Parameters_pattern>>.

    # $parameters is a Bio::FastParsers::Blast::Xml::Parameters
    my $pattern = $parameters->pattern;

This method does not accept any arguments.

=head2 sc_match

Returns the value of the element C<<Parameters_sc-match>>.

    # $parameters is a Bio::FastParsers::Blast::Xml::Parameters
    my $sc_match = $parameters->sc_match;

This method does not accept any arguments.

=head2 sc_mismatch

Returns the value of the element C<<Parameters_sc-mismatch>>.

    # $parameters is a Bio::FastParsers::Blast::Xml::Parameters
    my $sc_mismatch = $parameters->sc_mismatch;

This method does not accept any arguments.

=head1 ALIASES

=head2 evalue

Alias for C<expect> method. For API consistency.

=head1 AUTHOR

Denis BAURAIN <denis.baurain@uliege.be>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2013 by University of Liege / Unit of Eukaryotic Phylogenomics / Denis BAURAIN.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
