# Copyright (C) 2001-2004 Daniel Berrange <dan@berrange.com>
#
# $Id: Text-Smart-Plugin.spec.PL,v 1.3 2004/12/31 16:06:20 dan Exp $

use strict;

die unless (scalar @ARGV == 1);

unless (do 'lib/Text/Smart/Plugin.pm')
  {
    if ($@) { die $@ };
    die "lib/Text/Smart/Plugin.pm: $!";
  }
		
local $/ = undef;
$_ = <DATA>;
s/\@VERSION\@/$Text::Smart::Plugin::VERSION/g;

open SPEC, ">$ARGV[0]" or die "$!";
print SPEC $_;
close SPEC;
__DATA__
# Automatically generated by Text-Smart-Plugin.spec.PL

%define perlvendorarch %(perl -e 'use Config; print $Config{installvendorarch}')
%define perlvendorlib %(perl -e 'use Config; print $Config{installvendorlib}')
%define perlvendorprefix %(perl -e 'use Config; print $Config{vendorprefix}')
%define perlvendorman3 %{perlvendorprefix}/share/man/man3
%define perlversion %(perl -e 'use Config; print $Config{version}')

%define appname Text-Smart-Plugin

Summary: Text::Smart::Plugin - Simple text markup processor
Name: perl-%{appname}
Version: @VERSION@
Release: 1
License: GPL
Group: Applications/Internet
Source: %{appname}-%{version}.tar.gz
BuildRoot: /var/tmp/%{appname}-%{version}-root
BuildArchitectures: noarch
Requires: perl >= %{perlversion}
Requires: perl-Text-Smart >= 1.0.0
Requires: perl-Template-Toolkit

%description
Text::Smart::Plugin provides a module for simple inline text
markup processing.
 
%prep
%setup -q -n %{appname}-%{version}


%build
perl Makefile.PL PREFIX=$RPM_BUILD_ROOT/usr INSTALLDIRS=vendor
make


%install
rm -rf $RPM_BUILD_ROOT
make install INSTALLVENDORMAN3DIR=$RPM_BUILD_ROOT%{perlvendorman3}
find $RPM_BUILD_ROOT -name perllocal.pod -exec rm -f {} \;
find $RPM_BUILD_ROOT -name .packlist -exec rm -f {} \;

%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root)
%doc AUTHORS
%doc COPYING
%doc README
%{perlvendorman3}/*
%{perlvendorlib}/Text/Smart/Plugin.pm

