package OpenInteract::Page::Database;

# $Id: Database.pm,v 1.6 2002/01/30 17:50:13 lachoy Exp $

use strict;

sub load {
    my ( $class, $page ) = @_;
    my $R = OpenInteract::Request->instance;
    my $page_content = eval { $page->page_content };
    if ( $@ ) {
        $R->scrib( 0, "Error retrieving content from database. Error: $@\n",
                      SPOPS::Error->get->{system_msg} );
    }
    $R->DEBUG && $R->scrib( 1, "Page content location fetched from DB: ($page_content->{location})" );
    return $page_content->{content};
}


sub save {
    my ( $class, $page, $content ) = @_;
    my $R = OpenInteract::Request->instance;
    my $page_content = eval { $page->page_content } || $R->page_content->new;
    $page_content->{location} = $page->{location};

    if ( ! ref $content ) {
        $page_content->{content} = $content;
    }

    elsif ( ref $content eq 'SCALAR' ) {
        $page_content->{content} = $$content;
    }

    else {
        local $/ = undef;
        $page_content->{content} = <$content>;
    }

    return $page_content->save;
}


# This is a no-op for us, since the location will have been renamed
# properly in the upgrade

sub rename { return 1 }

sub remove {
    my ( $class, $page ) = @_;
    my $page_content = eval { $page->page_content };
    return $page_content->remove;
}

1;
