# stag-handle.pl -p GO::Parsers::GoOntParser -m <THIS> function/function.ontology

package GO::Handlers::prolog;
use base qw(GO::Handlers::abstract_prolog_writer 
	    Data::Stag::Writer);
use strict;

sub s_obo {
    my $self = shift;
    $self->cmt("-- ********************************************************* --\n");
    $self->cmt("-- Autogenerated Prolog factfiles \n");
    $self->cmt("-- class(Id,Name) -- corresponds to OBO term \n");
    $self->cmt("-- belongs(Id,Ont) -- maps ID to ontology/domain \n");
    $self->cmt("-- subclass(Id,IdParent) -- corresponds to is_a relationship \n");
    $self->cmt("-- restriction(Id,Type,To) -- other relationships \n");
    $self->cmt("-- ********************************************************* --\n");
    $self->nl;
}

sub e_typedef {
    my ($self, $typedef) = @_;
    $self->cmt("-- Property/Slot --\n");
    my $id = $typedef->get_id || $self->throw($typedef->sxpr);
    $self->fact(property => [$id, $typedef->sget_name]);
    my @is_as = $typedef->get_is_a;
    $self->fact('subclass', [$id, $_]) foreach @is_as;
    $self->nl;
    return;
}

sub e_term {
    my ($self, $term) = @_;
    my $id = $term->get_id || $self->throw($term->sxpr);
    my $name_h = $self->{name_h};
    my $name = $term->get_name;
    #$name =~ s/_/ /g;   # ontologies lack consistency; force use of spc
    my $ont = $term->get_namespace;
    my $def = $term->get_def;
    my $defstr = $def ? $def->sget_defstr : '';

    if ($term->get_is_obsolete) {
	$self->fact(obsolete => [$id,$name,$ont]);
	$self->fact(obsolete_class => [$id, $name]);
	return;
    }
    if ($name) {
	if (!$name_h) {
	    $name_h = {};
	    $self->{name_h} = $name_h;
	}
	$name_h->{$id} = $name;
	$self->cmt("-- $name --\n");
	$self->fact('class', [$id, $name]);
    }
    if ($ont) {
	$self->fact('belongs', [$id, $ont]);
    }
    if ($def) {
	# prolog doesn't need this for now - keep the db small
	# $self->fact('description', [$id, $def]);
    }
    my @is_as = $term->get_is_a;
    $self->fact('subclass', [$id, $_], $name_h->{$_}) foreach @is_as;
    my @rels = $term->get_relationship;
    $self->fact('restriction', 
		[$id, $_->get_type, $_->get_to], $name_h->{$_->get_to}) 
      foreach @rels;
    $self->nl;
    return;
}


1;
