package Acme::MetaSyntactic::invasions;
use strict;
use Acme::MetaSyntactic::List;
our @ISA = qw( Acme::MetaSyntactic::List );
our $VERSION = '1.000';
__PACKAGE__->init();
1;

=head1 NAME

Acme::MetaSyntactic::invasions - The naval and airborne invasions theme

=head1 DESCRIPTION

This list gives some codenames for naval invasions, paradrops and
operations with both a naval invasion component and an airborne
component during World War II. The list includes some operations which
were planned but not executed.

Source: among others, the I<Codeword Dictionnary>, 
Paul Adkins, Motorbooks International
(ISBN 0-7603-00368-1).

=head1 CONTRIBUTOR

Jean Forget

=head1 CHANGES

=over 4

=item *

2012-05-07 - v1.000

Received its own version number in Acme-MetaSyntactic-Themes version 1.000.

=item *

2006-09-18

Introduced in Acme-MetaSyntactic version 0.92,
on the 62nd anniversary of Market-Garden.

=item *

2006-06-14

Submitted by Jean Forget.

=back

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<Acme::MetaSyntactic::List>.

=cut

__DATA__
# names
Al Anvil Avalanche Baytown Coronet Detachment Dragoon Eclipse
Flintlock Gruener_Pfeil Herkules Husky Iceberg Ikarus Jubilee Leopard
Market_Garden Menace Merkur Mi Mo Oboe Olympic Overlord Roundhammer
Roundup Seeloewe Shingle Shoestring Slapstick Sledgehammer Torch
Varsity Victor Watchtower
