/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlNoFrames;
import com.gargoylesoftware.htmlunit.html.HtmlNoScript;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.EventHandler;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLScriptElement;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.PrintWriter;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlScript
extends HtmlElement {
    private static final long serialVersionUID = 5736570536821513938L;
    private static final Log LOG = LogFactory.getLog(HtmlScript.class);
    public static final String TAG_NAME = "script";
    private static final String SLASH_SLASH_COLON = "//:";

    HtmlScript(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    public final String getCharsetAttribute() {
        return this.getAttribute("charset");
    }

    public final String getTypeAttribute() {
        return this.getAttribute("type");
    }

    public final String getLanguageAttribute() {
        return this.getAttribute("language");
    }

    public final String getSrcAttribute() {
        return this.getAttribute("src");
    }

    public final String getEventAttribute() {
        return this.getAttribute("event");
    }

    public final String getHtmlForAttribute() {
        return this.getAttribute("for");
    }

    public final String getDeferAttribute() {
        return this.getAttribute("defer");
    }

    protected boolean isDeferred() {
        return this.getDeferAttribute() != ATTRIBUTE_NOT_DEFINED;
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        boolean ie;
        String oldValue = this.getAttributeNS(namespaceURI, qualifiedName);
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue);
        boolean execute = false;
        if (namespaceURI == null && "src".equals(qualifiedName) && ((ie = this.getPage().getWebClient().getBrowserVersion().isIE()) || oldValue.length() == 0 && this.getFirstChild() == null)) {
            execute = true;
        }
        if (execute) {
            this.executeScriptIfNeeded(true);
        }
    }

    @Override
    protected void onAllChildrenAddedToPage(boolean postponed) {
        if (this.getOwnerDocument() instanceof XmlPage) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Script node added: " + this.asXml()));
        }
        PostponedAction action = new PostponedAction(this.getPage()){

            public void execute() {
                boolean ie = HtmlScript.this.getPage().getWebClient().getBrowserVersion().isIE();
                if (ie) {
                    if (!HtmlScript.this.isDeferred()) {
                        if (!HtmlScript.this.getSrcAttribute().equals(HtmlScript.SLASH_SLASH_COLON)) {
                            HtmlScript.this.setAndExecuteReadyState("loading");
                            HtmlScript.this.executeScriptIfNeeded(true);
                            HtmlScript.this.setAndExecuteReadyState("loaded");
                        } else {
                            HtmlScript.this.setAndExecuteReadyState("complete");
                            HtmlScript.this.executeScriptIfNeeded(true);
                        }
                    }
                } else {
                    HtmlScript.this.executeScriptIfNeeded(true);
                }
            }
        };
        if (postponed && this.getTextContent().length() == 0) {
            JavaScriptEngine engine = this.getPage().getWebClient().getJavaScriptEngine();
            engine.addPostponedAction(action);
        } else {
            try {
                action.execute();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    private void executeInlineScriptIfNeeded(boolean executeIfDeferred) {
        if (!this.isExecutionNeeded()) {
            return;
        }
        boolean ie = this.getPage().getWebClient().getBrowserVersion().isIE();
        if (!executeIfDeferred && this.isDeferred() && ie) {
            return;
        }
        String src = this.getSrcAttribute();
        if (src != HtmlElement.ATTRIBUTE_NOT_DEFINED) {
            return;
        }
        DomCharacterData textNode = (DomCharacterData)this.getFirstChild();
        String forr = this.getHtmlForAttribute();
        String event = this.getEventAttribute();
        if (event.endsWith("()")) {
            event = event.substring(0, event.length() - 2);
        }
        String scriptCode = textNode.getData();
        if (ie && event != ATTRIBUTE_NOT_DEFINED && forr != ATTRIBUTE_NOT_DEFINED) {
            if ("window".equals(forr)) {
                Window window = (Window)this.getPage().getEnclosingWindow().getScriptObject();
                EventHandler function = new EventHandler(this, event, scriptCode);
                window.jsxFunction_attachEvent(event, (Function)function);
            } else {
                try {
                    Object elt = ((HtmlPage)this.getPage()).getHtmlElementById(forr);
                    ((HtmlElement)elt).setEventHandler(event, scriptCode);
                }
                catch (ElementNotFoundException e) {
                    LOG.warn((Object)("<script for='" + forr + "' ...>: no element found with id \"" + forr + "\". Ignoring."));
                }
            }
        } else if (forr == ATTRIBUTE_NOT_DEFINED || "onload".equals(event)) {
            String url = this.getPage().getWebResponse().getRequestSettings().getUrl().toExternalForm();
            int line1 = this.getStartLineNumber();
            int line2 = this.getEndLineNumber();
            int col1 = this.getStartColumnNumber();
            int col2 = this.getEndColumnNumber();
            String desc = "script in " + url + " from (" + line1 + ", " + col1 + ") to (" + line2 + ", " + col2 + ")";
            ((HtmlPage)this.getPage()).executeJavaScriptIfPossible(scriptCode, desc, line1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void executeScriptIfNeeded(boolean executeIfDeferred) {
        if (!this.isExecutionNeeded()) {
            return;
        }
        HtmlPage page = (HtmlPage)this.getPage();
        BrowserVersion browser = page.getWebClient().getBrowserVersion();
        boolean ie = browser.isIE();
        if (!executeIfDeferred && this.isDeferred() && ie) {
            return;
        }
        String src = this.getSrcAttribute();
        if (src.equals(SLASH_SLASH_COLON)) {
            return;
        }
        if (src != ATTRIBUTE_NOT_DEFINED) {
            if (src.startsWith("javascript:")) {
                String code;
                int len;
                if (ie && browser.getBrowserVersionNumeric() == 7.0f || (len = (code = StringUtils.removeStart((String)src, (String)"javascript:").trim()).length()) <= 2 || (code.charAt(0) != '\'' || code.charAt(len - 1) != '\'') && (code.charAt(0) != '\"' || code.charAt(len - 1) != '\"')) return;
                code = code.substring(1, len - 1);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Executing JavaScript: " + code));
                }
                page.executeJavaScriptIfPossible(code, code, this.getStartLineNumber());
                return;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loading external JavaScript: " + src));
                }
                try {
                    HtmlPage.JavaScriptLoadResult result = page.loadExternalJavaScriptFile(src, this.getCharsetAttribute());
                    if (result == HtmlPage.JavaScriptLoadResult.SUCCESS) {
                        this.executeEventIfNotIE("load");
                        return;
                    }
                    if (result != HtmlPage.JavaScriptLoadResult.DOWNLOAD_ERROR) return;
                    this.executeEventIfNotIE("error");
                    return;
                }
                catch (FailingHttpStatusCodeException e) {
                    this.executeEventIfNotIE("error");
                    throw e;
                }
            }
        } else {
            if (this.getFirstChild() == null) return;
            this.executeInlineScriptIfNeeded(executeIfDeferred);
        }
    }

    private void executeEventIfNotIE(String type) {
        if (!this.getPage().getWebClient().getBrowserVersion().isIE()) {
            HTMLScriptElement script = (HTMLScriptElement)this.getScriptObject();
            Event event = new Event(this, type);
            script.executeEvent(event);
        }
    }

    private boolean isExecutionNeeded() {
        SgmlPage page = this.getPage();
        if (!page.getWebClient().isJavaScriptEnabled()) {
            return false;
        }
        if (page instanceof HtmlPage && ((HtmlPage)page).isParsingHtmlSnippet()) {
            return false;
        }
        for (DomNode o = this; o != null; o = o.getParentNode()) {
            if (!(o instanceof HtmlInlineFrame) && !(o instanceof HtmlNoFrames) && !(o instanceof HtmlNoScript)) continue;
            return false;
        }
        if (page.getEnclosingWindow() != null && page.getEnclosingWindow().getEnclosedPage() != page) {
            return false;
        }
        if (!this.isJavaScript(this.getTypeAttribute(), this.getLanguageAttribute())) {
            String t = this.getTypeAttribute();
            String l = this.getLanguageAttribute();
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Script is not JavaScript (type: " + t + ", language: " + l + "). Skipping execution."));
            }
            return false;
        }
        DomNode root = this;
        while (root.getParentNode() != null) {
            root = root.getParentNode();
        }
        return root == this.getPage();
    }

    boolean isJavaScript(String typeAttribute, String languageAttribute) {
        boolean isJavaScript = typeAttribute != null && typeAttribute.length() != 0 ? typeAttribute.equalsIgnoreCase("text/javascript") || typeAttribute.equalsIgnoreCase("application/javascript") && this.getPage().getWebClient().getBrowserVersion().isFirefox() : (languageAttribute != null && languageAttribute.length() != 0 ? TextUtil.startsWithIgnoreCase(languageAttribute, "javascript") : true);
        return isJavaScript;
    }

    protected void setAndExecuteReadyState(String state) {
        if (this.getPage().getWebClient().getBrowserVersion().isIE()) {
            this.setReadyState(state);
            HTMLScriptElement script = (HTMLScriptElement)this.getScriptObject();
            Event event = new Event(this, "readystatechange");
            script.executeEvent(event);
        }
    }

    @Override
    public String asText() {
        return "";
    }

    @Override
    protected boolean isEmptyXmlTagExpanded() {
        return true;
    }

    @Override
    protected void printChildrenAsXml(String indent, PrintWriter printWriter) {
        DomCharacterData textNode = (DomCharacterData)this.getFirstChild();
        if (textNode != null) {
            printWriter.println("//<![CDATA[");
            printWriter.println(textNode.getData());
            printWriter.println("//]]>");
        }
    }
}

